// UnixProp.java
// $Id: UnixProp.java,v 1.4 1997/03/12 10:50:18 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.io.* ;
import java.util.* ;

import w3c.tools.store.*;
import w3c.www.http.*;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.forms.* ;
import w3c.jigsaw.daemon.*;
import w3c.jigsaw.config.*;

/**
 * A wrapper class to give access to editable properties through a resource.
 * This class wraps UNIX specific properties.
 */

class UnixProp extends PropertySet {
    private static String title = "Unix properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.http.UnixProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Group
	a = new StringAttribute(httpd.SERVER_GROUP_P
				, null
				, Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// User
	a = new IntegerAttribute(httpd.SERVER_USER_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    UnixProp(String name, httpd server) {
	super(name, server);
    }
}

