// LookupResult.java
// $Id: LookupResult.java,v 1.1 1996/07/19 23:59:55 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http ;

// FIXME The dependency on this should be described by an interface in http
import w3c.jigsaw.resources.*;

// FIXME doc

public class LookupResult {
    public static final int FILTERS_INIT_SIZE = 8;
    public static final int FILTERS_INCR      = 4;

    /**
     * Any reply that can be computed during lookup.
     */
    protected Reply reply = null;
    /**
     * The current target of the lookup operation.
     */
    protected HTTPResource target = null;
    /**
     * The current set of computed filters to be applied on the resource.
     */
    protected HTTPFilter filters[] = null;
    /**
     * The number of registered filters at this point.
     */
    protected int flength = -1;

    /**
     * Get the current lookup target of the lookup in progress.	
     * @return An HTTPResource, that may be <strong>null</strong>.
     */

    public HTTPResource getTarget() {
	return target;
    }

    /**
     * Set the current target of the lookup operation.
     * @param target The new current target of the lookup in progress.
     */

    public void setTarget(HTTPResource target) {
	this.target = target;
    }

    // FIXME doc
    public Reply getReply() {
	return reply;
    }

    // FIXME doc
    public void setReply(Reply reply) {
	this.reply = reply;
    }

    // FIXME doc
    public boolean hasReply() {
	return reply != null;
    }

    /**
     * Add a filter, to be invoked by the resource's <code>perform</code> 
     * method.
     * @param filter The HTTPFIlter to be called.
     */

    public void addFilter(HTTPFilter filter) {
	if ( filters == null ) {
	    // Create the filters array:
	    filters = new HTTPFilter[FILTERS_INIT_SIZE];
	    flength = 0;
	    filters[flength++] = filter;
	} else {
	    if ( flength >= filters.length ) {
		// Resize the filters array:
		HTTPFilter nf[] = new HTTPFilter[filters.length+FILTERS_INCR];
		System.arraycopy(filters, 0, nf, 0, filters.length);
		filters = nf;
	    }
	    filters[flength++] = filter;
	}
	return;
    }

    /**
     * Add a set of filters to be invoked by the resource's <code>
     * perform</code> method.
     * @param filters The array of filters to register.
     */

    public void addFilters(HTTPFilter fs[]) {
	if ( filters == null ) {
	    flength = fs.length;
	    filters = new HTTPFilter[Math.max(FILTERS_INIT_SIZE, flength)];
	    System.arraycopy(fs, 0, filters, 0, flength);
	} else {
	    int rs = flength + fs.length;
	    if ( rs >= filters.length ) {
		int ns = Math.max(rs ,filters.length+FILTERS_INCR);
		HTTPFilter nf[] = new HTTPFilter[ns];
		System.arraycopy(filters, 0, nf, 0, flength);
		filters = nf;
	    }
	    System.arraycopy(fs, 0, filters, flength, fs.length);
	    flength += fs.length;
	}
	return;
    }

    /**
     * Get the full list of filters to be applied when performing on the 
     * resource.
     * @return An array of HTTPFilter instances, or <strong>null</strong>
     * if none is defined.
     */

    public HTTPFilter[] getFilters() {
	if ( filters != null ) {
	    // Fix the filter array size first:
	    if ( filters.length != flength ) {
		HTTPFilter f[] = new HTTPFilter[flength];
		System.arraycopy(filters, 0, f, 0, flength);
		filters = f;
	    }
	}
	return filters;
    }

    /**
     * Create a new empty lookup result object.
     * @param target The root target of the lookup operation to run.
     */

    public LookupResult(HTTPResource target) {
	this.target = target;
    }
}
