// ConnectionProp.java
// $Id: ConnectionProp.java,v 1.7 1997/03/12 10:50:07 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.io.* ;
import java.util.* ;

import w3c.tools.store.*;
import w3c.www.http.*;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.forms.* ;
import w3c.jigsaw.daemon.*;
import w3c.jigsaw.config.*;

/**
 * A wrapper class to give access to editable properties through a resource.
 * This class allows to reuse entirely the generic resource editor to
 * edit the properties of the server.
 */

class ConnectionProp extends PropertySet {
    private static String title = "Connection properties";

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.http.ConnectionProp");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Keep-Alive flag:
	a = new BooleanAttribute(httpd.KEEP_ALIVE_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Client's threads priority:
	a = new IntegerAttribute(httpd.CLIENT_PRIORITY_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Client's buffer size
	a = new IntegerAttribute(httpd.CLIENT_BUFSIZE_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Client's debug flag
	a = new BooleanAttribute(httpd.CLIENT_DEBUG_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
	// Request time out:
	a = new IntegerAttribute(httpd.REQUEST_TIMEOUT_P
				 , null
				 , Attribute.EDITABLE);
	AttributeRegistry.registerAttribute(c, a);
    }

    /**
     * Get this property set title.
     * @return A String encoded title.
     */

    public String getTitle() {
	return title;
    }

    ConnectionProp(String name, httpd server) {
	super(name, server);
    }
}

