// HtmlLink.java
// $Id: HtmlLink.java,v 1.1 1996/11/15 13:30:41 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.html ;

import java.io.* ;

/*
 * The link element contained in the HEAD of an html document
 */

public class HtmlLink {
    String href  = null;
    String rel   = null;
    String rev   = null;
    String title = null;

    /**
     * genereate a String representation that can be
     * append in a HTML document
     */

    public String toString()
    {
	return "<LINK" 
	       + ((href != null) ? " HREF=\""+href+"\"" : "")
	       + ((rel != null) ? " REL=\""+rel+"\"" : "")
	       + ((rev != null) ? " REV=\""+rel+"\"" : "")
	       + ((title != null) ? " TITLE=\""+rel+"\"" : "")
	       + ">\n";
    }
    
    /**
     * Create a link with only REL and HREF part
     * @param rel, String part of rel
     * @param href, String form of an URL or relative URL
     */

    public HtmlLink(String rel, String href)
    {
	this.rel  = rel;
	this.href = href;
    }
    
    /**
     * Create a link with only HREF part (not very useful)
     * @param href, String form of an URL or relative URL
     */

    public HtmlLink(String href)
    {
	this.href = href;
    }
    
    /**
     * Create a link with only REL and HREF part
     * @param rev, String definition of rev
     * @param rel, String definition of rel
     * @param href, String form of an URL or relative URL
     */

    public HtmlLink(String rev, String rel, String href)
    {
	this.rev  = rev;
	this.rel  = rel;
	this.href = href;	
    }

     /**
     * Create a complete link 
     * @param rev, String definition of rev
     * @param rel, String definition of rel
     * @param href, String form of an URL or relative URL
     * @param title, String title
     */

    public HtmlLink(String rev, String rel, String href, String title)
    {
	this.rev   = rev;
	this.rel   = rel;
	this.href  = href;	
	this.title = title;
    }   
}
