// ClassnameField.java
// $Id: ClassnameField.java,v 1.3 1996/07/03 15:05:43 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

public class ClassnameField extends TextField {
    Class cls = null ;

    public Object getValue () {
	return cls ;
    }

    public boolean setValue (String nval) 
	throws FormFieldException
    {
	// Unset the class field ?
	if ((nval == null) || nval.equals("")) {
	    boolean result = (cls != null) ;
	    cls = null ;
	    return result ;
	}
	// Try the value as a class name.
	if ( super.setValue (nval) ) {
	    try {
		cls = Class.forName(nval) ;
	    } catch (Exception ex) {
		String msg = "Invalid class name: "+nval+". Check the name of "
		    + " the class for a typo, and then, check your CLASSPATH "
		    + " variable.";
		throw new FormFieldException (msg) ;
	    }
	    return true ;
	}
	return false ;
    }

    /*
     * Initialize a ClassnameField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	super.initialize(name, title, url, null) ;
	try {
	    this.cls   = (Class) val ;
	    this.value = (cls == null) ? "" : cls.getName() ;
	} catch (ClassCastException ex) {
	    String msg = "Invalid type: "+val.getClass().getName() ;
	    throw new FormFieldException (msg) ;
	}
    }


    public ClassnameField (String name,String title,String url, String c) {
	super (name, title, url, c) ;
    }

    public ClassnameField() {
    }

}
