// AuthRealmResource.java
// $Id: AuthRealmResource.java,v 1.3 1997/07/23 15:03:43 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.auth;

import java.util.*;
import w3c.tools.store.*;
import w3c.jigsaw.resources.*;
import w3c.jigsaw.http.*;

public class AuthRealmResource extends HTTPResource 
                               implements ContainerInterface {
    protected AuthRealm realm = null;
 
    // No direct access to the underlying store

    public boolean hasResourceStore() {
	return false;
    }
    
    public ResourceStore getResourceStore(ResourceStoreHolder holder) {
	return null;
    }

    public Enumeration enumerateResourceIdentifiers(boolean all) {
	if( realm == null ) {
	    return null;
	}
	return realm.enumerateUserNames();
    }
    
    public Resource lookup(String name) {
	if( realm == null ) {
	    return null;
	}
	return realm.loadUser(name);
    }   
    
    // delete this realm

    public void delete() {
	if (realm == null) 
	    return;
	realm.delete();
    }

    public void delete(String name) {
	if( realm == null ) {
	    return;
	}
	realm.unregisterUser(name);
    }
    
    public void registerResource(String name,
				 Resource resource,
				 Hashtable defs) {
	if(realm == null)
	    return;
	if( resource instanceof AuthUser) {
	    realm.registerUser(AuthUser.makeUser(name));
	}
    }

    public AuthRealmResource(AuthRealm realm) {
	this.realm = realm;
    }
    
    public AuthRealmResource() {
	// empty constructor for ResourceBroker
    }
}
