// UsersHelper.java
// $Id: UsersHelper.java,v 1.4 1997/08/21 09:33:04 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigadm.editors ;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import w3c.jigadm.*;
import w3c.jigsaw.admin.*;
import w3c.tools.store.Attribute;

public class UsersHelper extends ResourceHelper {

    private class AddUserListener implements ActionListener {
    
        public void actionPerformed(ActionEvent ae) {
	    addUser();
	}
    }

    RemoteResourceWrapper   rrw = null;
    RemoteResource rr = null;
    private boolean initialized = false;
    TextField tf;
    Panel widget;

    protected void addUser() {
	if(tf.getText().length() > 0) {
	    RemoteResource nrr;
	    try {
		nrr = rrw.getResource().
		    registerResource(tf.getText(),
				     "w3c.jigsaw.auth.AuthUser");
	    } catch (RemoteAccessException ex) {
	        errorPopup("RemoteAccessException",ex);
		return;
	    }
	    RemoteResourceWrapper nrrw;
	    nrrw = new RemoteResourceWrapper(rrw, nrr, rrw.getBrowser());
	    rrw.getBrowser().insertNode(rrw, nrrw, tf.getText());
	}
    }

    protected RemoteResourceWrapper getWrapper() {
	return rrw;
    }

    public Component getComponent() {
	return widget;
    }

    public void commitChanges() {
    }

    public boolean hasChanged() {    
	return false;
    }

    public void resetChanges() {
    }

    public void clearChanged() {
    }

    public final String getTitle () {
	return "Users";
    }

    public UsersHelper() {
	widget = new Panel();
    }

    protected void initAddPanel() {
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();
	AddUserListener aul = new AddUserListener();
	Panel p = new Panel(gbl);
	Label l;
	gbc.fill = GridBagConstraints.HORIZONTAL;
	gbc.weightx = 0;
	gbc.weighty = 0;	
	tf = new TextField(15);
	tf.addActionListener(aul);
	l = new Label("User name", Label.RIGHT);
	gbc.gridwidth = 1;
	gbl.setConstraints(l, gbc);
	p.add(l);
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbl.setConstraints(tf, gbc);
	p.add(tf);
	widget.add("Center", p);
	Button newb     = new Button("Add User");
	newb.addActionListener(aul);
	widget.add("South", newb);
    }


    public void initialize(RemoteResourceWrapper rrw, Properties pr)
	throws RemoteAccessException
    {
	if(!initialized)
	    initialized = true;
	else
	    return;	
	
	this.rrw = rrw;
	rr = rrw.getResource();

	if(rr.isContainer()) {
	    widget.setLayout(new BorderLayout());
	    initAddPanel();
	}
    }
}
