// PassDIrectoryShortcut.java
// $Id: PassDirectoryShortcut.java,v 1.3 1997/07/07 13:29:31 ylafon Exp $
// (c) COPYRIGHT MIT and INRIA, 1997.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigadm.editors;

import java.awt.*;
import java.io.*;
import java.awt.event.*;
import java.util.*;
import w3c.jigadm.*;
import w3c.jigsaw.admin.*;
import w3c.tools.store.Attribute;

public class PassDirectoryShortcut {

    private class AddPassListener implements ActionListener {
    
        public void actionPerformed(ActionEvent ae) {
	    addPassDirectory();
	}
    }

    RemoteResourceWrapper rrw;
    ShortcutHelper sh;
    Panel widget;
    TextField itf;
    TextField atf;

    public void initialize(RemoteResourceWrapper rrw, Properties p) {
	this.rrw = rrw;

	ScrollPane fsp = new ScrollPane();
	GridBagLayout gbl = new GridBagLayout();
	GridBagConstraints gbc = new GridBagConstraints();
	Panel fspp = new Panel(gbl);
	Button b;

	fsp.add(fspp);
	Label l;
	l = new Label("Directory Name");
	gbc.gridwidth = 1;
	gbl.setConstraints(l, gbc);
	fspp.add(l);
	
	itf = new TextField(20);
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbl.setConstraints(itf, gbc);
	fspp.add(itf);

	l = new Label("Pointing to");
	gbc.gridwidth = 1;
	gbl.setConstraints(l, gbc);
	fspp.add(l);
	
	atf = new TextField(20);
	gbc.gridwidth = GridBagConstraints.REMAINDER;
	gbl.setConstraints(atf, gbc);
	fspp.add(atf);

	b = new Button("Add");
	b.addActionListener(new AddPassListener());
	gbl.setConstraints(b, gbc);
	fspp.add(b);
	widget.add("Center", fspp);
    }

    protected void addPassDirectory() {
	RemoteResourceWrapper nrrw;
	AttributeEditor ae;
	
	nrrw = sh.addResource(itf.getText(),
			      "w3c.jigsaw.resources.PassDirectory");
	if(nrrw != null) {
	    try {
		nrrw.getResource().setValue("pass-target",
					    new File(atf.getText()));
	    } catch (RemoteAccessException ex) {
		// fancy thing
	    }
	}
    }

    public Component getComponent() {
	return widget;
    }

    public PassDirectoryShortcut(ShortcutHelper sh) {
	this.sh = sh;
	widget = new Panel(new BorderLayout());
    }
}
