// HttpTokenList.java
// $Id: HttpTokenList.java,v 1.9 1996/09/23 14:01:16 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.www.http;

import java.util.*;

/**
 * Parse a comma separated list of tokens.
 */

public class HttpTokenList extends BasicValue {
    String tokens[] = null ;

    /**
     * Parse the byte buffer to build the token list.
     */

    protected void parse() {
	Vector     toks = new Vector(8);
	ParseState ps   = new ParseState();
	ParseState it   = new ParseState();
	
	ps.ioff       = roff;
	ps.bufend     = rlen;
	ps.spaceIsSep = false;
	while(HttpParser.nextItem(raw, ps) >= 0) {
	    it.ioff   = ps.start;
	    it.bufend = ps.end;
	    HttpParser.unquote(raw, it);
	    toks.addElement(it.toString(raw, true));
	    ps.prepare();
	}
	tokens = new String[toks.size()];
	toks.copyInto(tokens);
    }

    protected void updateByteValue() {
	HttpBuffer buf = new HttpBuffer();
	for (int i = 0 ; i < tokens.length ; i++) {
	    if ( i > 0 )
		buf.append(',');
	    buf.append(tokens[i]);
	}
	raw  = buf.getByteCopy();
	roff = 0;
	rlen = raw.length;
    }

    /**
     * Get this token list value.
     * @return A list of tokens, encoded as a String array, or <strong>null
     *    </strong> if undefined.
     */

    public Object getValue() {
	validate();
	return tokens;
    }

    public void setValue(String tokens[]) {
	invalidateByteValue() ;
	this.tokens = tokens ;
	isValid = true ;
    }

    /**
     * Add a token to this token list.
     * @param token The token to add.
     * @param always Always add to the list, even if the token us already 
     * present in the list.
     */

    public void addToken(String token, boolean always) {
	validate();
	// Check if already set:
	if ( ! always ) {
	    if ( tokens != null ) {
		for (int i = 0 ; i < tokens.length ; i++)
		    if ( tokens[i].equals(token) )
			return;
	    }
	}
	// Add it to the token list:
	invalidateByteValue();
	if ( tokens == null ) {
	    tokens    = new String[1];
	    tokens[0] = token;
	} else {
	    String newtoks[] = new String[tokens.length+1];
	    System.arraycopy(tokens, 0, newtoks, 0, tokens.length);
	    newtoks[tokens.length] = token;
	    tokens = newtoks;
	}
    }

    /**
     * Does this token list includes that token ?
     * @param token The token to look for.
     * @return A boolean, <strong>true</strong> if found, 
     * <strong>false</strong> otherwise.
     */

    public boolean hasToken(String token, boolean caseSensitive) {
	validate();
	if ( tokens == null )
	    return false;
	if ( caseSensitive ) {
	    for (int i = 0 ; i < tokens.length ; i++)
		if ( tokens[i].equals(token) )
		    return true;
	} else {
	    for (int i = 0 ; i < tokens.length ; i++) 
		if ( tokens[i].equalsIgnoreCase(token) )
		    return true;
	}
	return false;
    }
     
    /**
     * Create a parsed token list, for emitting.
     */

    HttpTokenList(String tokens[]) {
	this.isValid = true;
	this.tokens  = tokens;
    }

    /**
     * Create a token list from a comma separated list of tokens.
     */

    HttpTokenList(String tokens) {
	this.isValid = false;
	this.raw     = new byte[tokens.length()];
	tokens.getBytes(0, raw.length, raw, 0);
	this.roff    = 0;
	this.rlen    = raw.length;
    }

    /**
     * Create an empty token list for parsing.
     */

    HttpTokenList() {
	this.isValid = false ;
    }

}
