// AsyncLRUList.java
// $Id: AsyncLRUList.java,v 1.7 1996/09/27 22:13:53 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.util ;

// All locks allocated from left to right

public class AsyncLRUList extends LRUList {
    public void toHead(LRUAble node) {
	_remove(node) ;

	synchronized(head) {
	    if ( head.next != null ) {
		synchronized(head.next) {
		    synchronized (node) {
			node.setNext(head.next) ;
			head.next.setPrev(node) ;
			node.setPrev(head) ;
			head.next = node ;
		    }
		}
	    } else {
		synchronized (node) {
		    node.setNext(head.next) ;
		    // head.next.setPrev(node) ;
		    node.setPrev(head) ;
		    head.next = node ;
		}
	    }
	}
    }
	    
    public void toTail(LRUAble node) {
	_remove(node) ;

	synchronized (node) {
	    if ( tail.prev != null ) {
		synchronized(tail.prev) {
		    synchronized(tail) {
			node.setPrev(tail.prev) ;
			tail.prev.setNext(node) ;
			node.setNext(tail) ;
			tail.prev = node ;
		    }
		}
	    } else {
		synchronized(tail) {
		    node.setPrev(tail.prev) ;
		    // tail.prev.setNext(node) ;
		    node.setNext(tail) ;
		    tail.prev = node ;
		}
	    }
	}
    }
	    

    private final void _remove(LRUAble node) {
	LRUAble itsPrev, itsNext ;
	synchronized(node) {
	    itsPrev = node.getPrev() ;
	    if(itsPrev==null) 
		return ;
	    itsNext = node.getNext() ;
	    node.setNext(null);
	    node.setPrev(null);
	}
	synchronized (itsPrev) {
	    itsPrev.setNext(itsNext) ;
	}
	if ( itsNext == null )
	    return;
	synchronized(itsNext) {
	    itsNext.setPrev(itsPrev) ;
	}
    }

    public final LRUAble remove(LRUAble node) {
	_remove(node) ;
	synchronized(node) {
	    node.setNext((LRUAble) null) ;
	    node.setPrev((LRUAble) null) ;
	}
	return node ;
    }

    public final LRUAble getTail() {
	if ( tail.prev == null )
	    return null;
	synchronized(tail.prev) {
	    synchronized(tail) {
		LRUAble prev = tail.prev ;
		return (prev == head) ? null : prev;
	    }
	}
    }

    public final LRUAble getHead() {
	synchronized(head) {
	    LRUAble next = head.next;
	    return (next == tail) ? null : next;
	}
    }

    public final LRUAble removeTail() {
	synchronized(tail.prev) {
	    synchronized(tail) {
		return (tail.prev != head) ? remove(tail.prev) : null;
	    }
	}
    }

    public final LRUAble getNext(LRUAble node) {
	LRUAble next = null;
	synchronized(node) {
	    next = node.getNext();
	    return ((next == tail) || (next == head)) ? null : next;
	}
    }

    public final LRUAble getPrev(LRUAble node) {
	LRUAble prev = null;
	synchronized(node) {
	    prev = node.getPrev();
	    return ((prev == tail) || (prev == head)) ? null : prev;
	}
    }

		
}
