// http.java
// $Id: http.java,v 1.2 1996/08/09 15:15:48 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.mux ;

import java.io.* ;
import java.net.* ;

/**
 * Each http object shares the same connection to get a binch of documents.
 */

public class http implements Runnable {
    private static char ch = 'A' ;

    MPStream stream = null ;
    String   path   = null ;
    Thread   thread = null ;

    synchronized String getIdentifier() {
	return (new Character(ch++)).toString() ;
    }

    void trace(String msg) {
	System.out.println (Thread.currentThread()+": "+msg) ;
    }

    public void run () {
	try {
	    Session s = stream.connect(80) ;
	    InputStream input = new BufferedInputStream(s.getInputStream());
	    // Send the request:
	    trace ("sending request for "+path) ;
	    DataOutputStream output = (new DataOutputStream
				       (new BufferedOutputStream
					(s.getOutputStream()))) ;
	    output.writeBytes("GET "+path+" HTTP/1.0\r\n\r\n") ;
	    output.flush() ;
	    // Get reply:
	    trace ("reading reply...") ;
	    byte buffer[] = new byte[4096] ;
	    int  got      = -1 ;
	    while ((got = input.read(buffer, 0, buffer.length)) > 0) {
		// System.out.println("*** got "+got+" bytes.");
		trace(new String(buffer, 0, 0, got)) ;
//		System.out.print(thread.getName()+"["+got+"]");
	    }
	    input.close() ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	}
    }

    public http (MPStream stream, String path) 
	throws IOException
    {
	this.stream = stream ;
	this.path   = path ;
	this.thread = new Thread(this) ;
	this.thread.start() ;
	this.thread.setName(getIdentifier()) ;
    }

    public static void main (String args[]) {
	try {
	    String   host   = args[0] ;
	    int      port   = Integer.parseInt(args[1]) ;
	    Socket   socket = new Socket (host, port) ;
	    MPStream stream = new MPStream (false, socket) ;
	    for (int i = 2 ; i < args.length ; i++)
		new http(stream, args[i]) ;
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	}
    }
}
