package w3c.jigsaw.tests ;

import java.io.* ;

import w3c.www.http.HTTP ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.* ;


public class DummyResource extends HTTPResource {
    private protected static byte[] dReply = null ;
    private protected Reply reply = null ;
    
    private protected final static String headers =
	"HTTP/1.0 200 OK\n" +
	"Date: Thu, 1 Aug 1996 00:00:00 GMT\n" +
	"Content-Length: 4096\n" +
	"Content-Type: text/plain\n" +
	"Last-Modified: Thu, 1 Aug 1996 00:00:00 GMT\n" +
	"\n" ;

    static {
	dReply = new byte[headers.length() + 4096] ;
				
	headers.getBytes(0,headers.length(),dReply,0) ;

	for(int i=headers.length();i<dReply.length;i++) 
	    dReply[i] = (byte) '*' ;
    }
    
    public Reply get(Request request)
	throws HTTPException 
    {
	if(reply==null) {
	    reply = request.makeReply(HTTP.NOHEADER) ;
	    reply.setHeaderValue(reply.H_CONTENT_LENGTH,null) ;
	    reply.setHeaderValue(reply.H_CONTENT_TYPE,null) ;
	    reply.setStream((InputStream) null) ;
	}

	try {
	    request.getClient().getOutputStream().write(dReply) ;
	} catch(IOException ex) {
	    reply.setStatus(HTTP.NOT_FOUND) ;
	    throw new HTTPException(reply) ;
	} 
	return reply ;
    }
}
