// FLastModCommand.java
// $Id: FLastModCommand.java,v 1.7 1996/08/22 19:07:47 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.www.http.HTTP ;
import w3c.util.* ;
import w3c.jigsaw.http.* ;
import w3c.jigsaw.resources.* ;

/**
 * Implementation of the standard <code>flastmod</code> SSI command.
 * @author Antonio Ramirez <anto@mit.edu>
 */
public class FLastModCommand extends BasicCommand {
    private final static String NAME = "flastmod" ;

    public Reply execute(SSIResource resource,
			 Request request,
			 ArrayDictionary parameters,
			 Dictionary variables)
    {
	Reply reply = resource.createCommandReply(request,HTTP.OK) ;
	reply.setContent(TimeFormatter
			 .format(new Date(resource
					  .getFile()
					  .lastModified()),
				 (String) variables.get("datefmt"))) ;

	handleSimpleIMS(request,reply) ;
	return reply ;
    }
    
    public String getName()
    {
	return NAME;
    }

}
