// Command.java
// $Id: Command.java,v 1.11 1996/08/22 19:07:42 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.ssi ;

import java.util.* ;

import w3c.util.* ;
import w3c.jigsaw.resources.* ;
import w3c.jigsaw.http.* ;

/**
 * This interface is used to supply implementations of SSI
 * commands. They have to be registered in a CommandRegistry, which in
 * turn is used by the SSIResource.
 *
 * @see w3c.jigsaw.ssi.CommandRegistry
 * @author Antonio Ramirez <anto@mit.edu>
 */

public interface Command {
    /**
     * Executes this command. Might modify variables.
     * Must <em>not</em> modify the parameters.
     * <P> It may handle conditional requests, <em>except</em> that if
     * it replies with a status of HTTP.NOT_MODIFIED, it <em>must</em>
     * still reply with a content (the same content that it would have
     * returned for an inconditional request).  This is because
     * further SSI commands down the line may decide thay they have
     * been modified, and then a content must be emitted by SSIResource.
     *
     * @param request the original HTTP request
     * @param parameters The parameters for this command
     * @param variables The global variables for the parse 
     * @return a Reply with the output from the command */
    public Reply execute(SSIResource resource,
			 Request request,
			 ArrayDictionary parameters,
			 Dictionary variables)
	;
    

    /** 
     * Returns the name of this command. <em>(Case sensitivity is up to
     * the <code>lookupCommand</code> method in the command registry.)</em>
     *
     * @return the name of the command
     * @see w3c.jigsaw.ssi.CommandRegistry#lookupCommand
     */

    public String getName() ;

}

