// VirtualHostResource.java
// $Id: VirtualHostResource.java,v 1.2 1996/10/03 21:20:55 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources;

import java.util.*;
import java.io.*;

import w3c.util.*;
import w3c.jigsaw.http.*;

public class VirtualHostResource extends DirectoryResource {
    /**
     * Attribute index - The list of virtual host we handle.
     */
    protected static int ATTR_HOSTS = -1;
    /**
     * Attribute index - The default root (for unknown hosts)
     */
    protected static int ATTR_FOLLOWUP = -1;
    /**
     * Attribute index - The directory we are attached to.
     */
    protected static int ATTR_DIRECTORY = -1;

    static {
	Class     c = null;
	Attribute a = null;

	try {
	    c = Class.forName("w3c.jigsaw.resources.VirtualHostResource");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Register our default root:
	a = new StringAttribute("followup"
				, null
				, Attribute.EDITABLE);
	ATTR_FOLLOWUP = AttributeRegistry.registerAttribute(c, a);
    }

    protected HTTPResource followup = null;
    protected Hashtable    defs     = null;

    /**
     * Create a default resource for that container.
     * This method will just fail, since they are no there is no specific
     * resource class to be attached to that class of resources.
     * @param name The name of the resource to be created.
     * @return Always <strong>null</strong>.
     */

    public HTTPResource createDefaultResource(String name) {
	return null;
    }

    /**
     * Resolve the given name in our store.
     * @param name The name to resolve.
     */

    protected synchronized HTTPResource lookupStore(String host) {
	ResourceStore store = getResourceStore();
	// Overide the host URL, now:
	defs.put("url", "http://"+host);
	return super.lookupStore(host, defs);
    }

    /**
     * Get the name of the resource used as a followup.
     * @return A String giving the name of the resource to be used as the
     * default.
     */

    public String getFollowup() {
	return getString(ATTR_FOLLOWUP, null);
    }

    /**
     * Lookup the followup resource.
     * @return The loaded resource for the current followup.
     */

    public synchronized HTTPResource lookupFollowup() {
	if ( followup == null ) {
	    ResourceStore store = getServer().getRoot().getResourceStore();
	    String        name  = getFollowup();
	    if ( name != null ) {
		Hashtable fdefs = (Hashtable) defs.clone();
		fdefs.put("directory", getDirectory());
		fdefs.put("url", getURL());
		try {
		    followup = (HTTPResource) store.loadResource(name, fdefs);
		} catch (InvalidResourceException ex) {
		    followup = null;
		}
	    }
	    if ( followup == null ) {
		getServer().errlog(getIdentifier()
				   + "[" + getClass().getName() + "]: "
				   + "unable to restore \"" + name + "\" "
				   + " from " + store + ".");
	    }
	}
	return followup;
    }

    /**
     * Lookup the virtual host resource to continue lookup.
     * This is one of the neatest piece of code that Jigsaw allows you to 
     * write.
     */

    public boolean lookup(LookupState ls, LookupResult lr) 
	throws HTTPException
    {
	// If this is an internal lookup, it's pretty easy:
	if ( ls.isInternal() ) {
	    return super.lookup(ls, lr);
	}
	// Try to lookup on the host header:
	HTTPResource vroot = null;
	Request r = ls.getRequest();
	if ( r != null ) {
	    String  host = r.getHost();
	    if ( host != null ) 
		vroot = lookupStore(host);
	}
	if ( vroot == null )
	    vroot  = lookupFollowup();
	// Check for what we got:
	return (vroot == null) ? super.lookup(ls, lr) : vroot.lookup(ls, lr);
    }

    public Reply perform(Request request, HTTPFilter filters[]) 
	throws HTTPException, ClientException
    {
	HTTPResource followup = lookupFollowup();
	if ( followup != null )
	    return followup.perform(request, filters);
	else
	    return super.perform(request, filters);
    }

    public void initialize(Object values[]) {
	super.initialize(values);
	// Initialize default attributes for our vritual resources:
	HTTPResource parent = getParent();
	defs = new Hashtable(11);
	defs.put("resource-store", getResourceStore());
	defs.put("server", getServer());
	defs.put("parent", this);
	if ( parent != null ) {
	    defs.put("url", parent.getURL());
	} else {
	    defs.put("url", getURL());
	}
    }

}
