// ObjectAttribute.java
// $Id: ObjectAttribute.java,v 1.1 1996/04/10 13:50:13 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources;

import java.io.* ;

/**
 * A generic Object attribute.
 * This attribute is usefull for attributes that are:
 * <ul>
 * <li>Have Object values.
 * <li>Need not be saved (have the DONTSAVE bit set).
 * </ul>
 */

public class ObjectAttribute extends Attribute {
    /**
     * The class for values of this attribute.
     */
    protected Class cls = null ;

    /**
     * Check that a value is allowed for this attribute.
     * @param value The value to check.
     * @return A boolean <strong>true</strong> if value is allowed.
     */

    public boolean checkValue(Object value) {
//	return (value instanceof cls) ;
	return true ;
    }

    /**
     * The ObjectAttribute values can't be pickled.
     */

    public void pickle(DataOutputStream out, Object obj) {
	throw new RuntimeException ("Can't pickle ObjectAttribute.");
    }

    /**
     * The ObjectAttribute values can't be unpickled.
     */

    public Object unpickle(DataInputStream in) {
	throw new RuntimeException("Can't unpickle ObjectAttribute.");
    }

    /**
     * Create a new ObjectAttribute instance.
     * @param name The name of the attribute.
     * @param cls The class for this attribute values.
     * @param def The default value for this attribute.
     * @param flags The attribute flags.
     */

    public ObjectAttribute(String name, Class cls, Object def, int flags) {
	super(name, def, flags) ;
	// Check consistency
	if ( ! checkFlag(DONTSAVE) ) {
	    String error = "ObjectAttribute can't pickle themselves." ;
	    throw new RuntimeException (error) ;
	}
	this.cls = cls ;
    }

    /**
     * Create a new ObjectAttribute instance.
     * @param name The name of the attribute.
     * @param cname The name class for this attribute values.
     * @param def The default value for this attribute.
     * @param flags The attribute flags.
     * @exception RuntimeException If we couldn't resolve the class name.
     */

    public ObjectAttribute(String name, String cname, Object def, int flags) {
	super(name, def, flags) ;
	// Check consistency:
	if ( ! checkFlag(DONTSAVE) ) {
	    String error = "ObjectAttribute can't pickle themselves." ;
	    throw new RuntimeException (error) ;
	}
	// Resolve the class:
	try {
	    this.cls = Class.forName(cname) ;
	} catch (Exception ex) {
	    throw new RuntimeException("unable to resolve class "+cname) ;
	}
    }


}
