// MimeTypeAttribute.java
// $Id: MimeTypeAttribute.java,v 1.1 1996/08/09 15:05:45 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

import w3c.www.mime.* ;

/**
 * The generic class of Mime type attributes.
 */

public class MimeTypeAttribute extends Attribute {

    /**
     * Is the given object a valid MimeTypeAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof MimeType) || (obj == null) ;
    }
     
    /**
     * Pickle a MIME type to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object t) 
	throws IOException
    {
	out.writeUTF(((MimeType) t).toString()) ;
    }

    /**
     * Unpickle a MIME type from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of String.
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	try {
	    return new MimeType(in.readUTF()) ;
	} catch (MimeTypeFormatException ex) {
	    throw new IOException("illegal MIME type.") ;
	}
    }
     

    public MimeTypeAttribute(String name, Object def, int flags) {
	super(name, def, flags) ;
    }
}
