// IntegerArrayAttribute.java
// $Id: IntegerArrayAttribute.java,v 1.1 1996/09/26 15:36:39 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an IntegerArrayAttribute.
 */

public class IntegerArrayAttribute extends Attribute {

    /**
     * Turn a IntegerArray attribute into a String.
     * We use the <em>normal</em> property convention, which is to separate
     * each item with a <strong>|</strong>.
     * @return A String based encoding for that value.
     */

    public String stringify(Object value) {
	if ((value == null) || ( ! (value instanceof int[])) )
	    return null;
	int          ai[] = (int[]) value;
	StringBuffer sb   = new StringBuffer();
	for (int i = 0 ; i < ai.length ; i++) {
	    if ( i > 0 )
		sb.append('|');
	    sb.append(ai[i]);
	}
	return sb.toString();
    }

    /**
     * Is the given object a valid IntegerArrayAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof int[]) ;
    }
     
    /**
     * Pickle a integer array to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public void pickle(DataOutputStream out, Object ia) 
	throws IOException
    {
	int is[] = (int[]) ia ;
	out.writeInt(is.length) ;
	for (int i = 0 ; i < is.length ; i++)
	    out.writeInt(is[i]) ;
    }

    /**
     * Unpickle an integer array from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of int[].
     * @exception IOException If some IO error occured.
     */

    public Object unpickle (DataInputStream in) 
	throws IOException
    {
	int  cnt  = in.readInt() ;
	int  is[] = new int[cnt] ;
	for (int i = 0 ; i < cnt ; i++)
	    is[i] = in.readInt() ;
	return is ;
    }
     
    public IntegerArrayAttribute(String name, String def[], int flags) {
	super(name, def, flags) ;
    }

}
