// DoubleAttribute.java
// $Id: DoubleAttribute.java,v 1.1 1996/04/10 13:49:48 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources ;

import java.io.* ;

/**
 * The generic description of an DoubleAttribute.
 */

public class DoubleAttribute extends Attribute {

    /**
     * Is the given object a valid DoubleAttribute value ?
     * @param obj The object to test.
     * @return A boolean <strong>true</strong> if okay.
     * @exception IllegalAttributeAccess If the provided value doesn't pass the
     *    test.
     */

    public boolean checkValue(Object obj) {
	return (obj instanceof Double) ;
    }
     
    /**
     * Pickle an double to the given output stream.
     * @param out The output stream to pickle to.
     * @param obj The object to pickle.
     * @exception IOException If some IO error occured.
     */

    public final void pickle(DataOutputStream out, Object d) 
	throws IOException
    {
	out.writeDouble(((Double) d).doubleValue()) ;
    }

    /**
     * Unpickle an integer from the given input stream.
     * @param in The input stream to unpickle from.
     * @return An instance of Double.
     * @exception IOException If some IO error occured.
     */

    public final Object unpickle (DataInputStream in) 
	throws IOException
    {
	return new Double(in.readDouble()) ;
    }
     
    /**
     * Create a description for a generic Double attribute.
     * @param name The attribute name.
     * @param def The default value for these attributes.
     * @param flags The associated flags.
     */

    public DoubleAttribute(String name, Double def, int flags) {
	super(name, def, flags) ;
    }

}

