// ContainerResource.java
// $Id: ContainerResource.java,v 1.4 1996/09/25 14:18:12 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.resources;

import java.util.*;

import w3c.jigsaw.http.* ;
import w3c.www.http.* ;
import w3c.www.mime.MimeType;

/**
 * The ContainerResource is a resource that can have children.
 * By defining the abstract method of that class, you allow the generic
 * ContainerResource editor to edit the content of your sub-class.
 */

public abstract class ContainerResource extends FilteredResource {
 
    /**
     * Initialize and register the given resource under the given name.
     * This method is called by the container resource editor to add
     * a new child to the resource. The instance of the child is already
     * created, but it is left up to the container to initialize the resource
     * with its own set of default attributes.
     * @param name The identifier of that resource in the container.
     * @param child The instantiated children resource to be added.
     * @param defs The set f default attribute values.
     */

    abstract public void registerResource(String name
					  , Resource child
					  , Hashtable defs);

    /**
     * Enumerate the children resource identifiers.
     * @return An enumeration of String, one item per child resource. In
     * principle, a <code>lookup</code> on each String should return a valid
     * resource (except if some other thread is fidling with the container).
     */

    abstract public Enumeration enumerateResourceIdentifiers();

    /**
     * Lookup a resource in that container.
     * Lookup a resource in that container.
     * @param name The name (od identifier) of the resource to lookup.
     * @return A instance of HTTPResource, or <strong>null</strong> if such
     * a resource doesn't exist.
     */

    abstract public HTTPResource lookup(String name);

    /**
     * Create a default child resource in that container.
     * This method is called by the editor to add a default resource
     * in the container under the given name. The meaning of <em>default</em>
     * is left up to the container here.
     * @param name The identifier for the new resource.
     */

    abstract public HTTPResource createDefaultResource(String name);

    /**
     * Looking up inside a filtered resource.
     * This is the place we apply the lookup filters, if any. If a filter
     * knows how to compute the reply (for example, if it maintains a cache)
     * then, it will return a <strong>true</strong> boolean indicating
     * that processing this request shouldn't go further ahead (it has been 
     * done).
     * @param ls The lookup state.
     * @param lr The in-progress lookup result.
     * @return A boolean <strong>true</strong> if the lookup process is done
     * (either becasue some reply was computed or because the target was found)
     * <strong>false</strong> if request lookup should continue normally.
     * @exception HTTPException If some error occured during lookup.
     */

    public boolean lookup(LookupState ls, LookupResult lr) 
	throws HTTPException
    {
	ResourceFilter filters[] = getFilters();
	if ( filters != null ) {
	    for (int i = 0 ; i < filters.length ; i++) {
		if ( filters[i] == null )
		    continue;
		if ( filters[i].lookup(ls, lr) )
		    return true;
	    }
	}
	return super.lookup(ls, lr);
    }

}
