// ProxyDirectory.java
// $Id: ProxyDirectory.java,v 1.11 1996/10/03 21:20:22 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.proxy ;

import java.net.*;

import w3c.www.http.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

/**
 * A proxy module for Jigsaw.
 */

public class ProxyDirectory extends ForwardDirectory {
    URL url = null;

    /**
     * Lookup for an proxied resource.
     * @param request The request whose URI is to be looked up.
     * @exception HTTPException If something fails.
     */

    public boolean lookup(LookupState ls, LookupResult lr) 
	throws HTTPException
    {
	boolean ret = super.lookup(ls, lr);
	if ( ls.isInternal() )
	    return ret;
	// Get the full URL from the request:
	Request request = ls.getRequest();
	URL     requrl  = request.getURL() ;
	if ((url != null)
	    && (requrl.getPort() == url.getPort())
	    && (requrl.getHost().equalsIgnoreCase(url.getHost()))) {
	    HTTPResource root = getLocalRootResource();
	    if ( root == null ) {
		lr.setTarget(this);
		return true;
	    }
	    return root.lookup(ls, lr);
	} else {
	    // Always invoke super lookup
	    request.setProxy(true);
	    lr.setTarget(this);
	    return true;
	}
    }

    /**
     * Update the URL in which we are installed.
     * @param values The default attribute values.
     */

    public void initialize(Object values[]) {
	super.initialize(values);
	try {
	    url = new URL(getURL());
	} catch (Exception ex) {
	}
    }
	
}
