// ForwardDirectory.java
// $Id: ForwardDirectory.java,v 1.5 1996/09/27 22:13:31 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.proxy ;

import java.net.*;
import java.io.* ;
import java.util.*;

import w3c.jigsaw.daemon.*;
import w3c.www.http.*;
import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

import w3c.www.protocol.http.cache.CacheFilter;

/**
 * A proxy module for Jigsaw.
 * This is really a proof-of-conpcept thing. It will no actually do any caching
 * right now, although plans are to use the w3c.tools.dbm package to maintain
 * a database of cached resources.
 * <p>It heavily relies on java net's library to do the client side of the
 * proxy handling, which <em>might</em> not be the right thing to do for the 
 * time being.
 */

public class ForwardDirectory extends HTTPResource {
    private static final boolean debug = true;
    private static boolean inited = false;

    /**
     * Attribute index - The local resource, if server-wide request.
     */
    protected static int ATTR_LOCAL_ROOT = -1;
    /**
     * Attribute index - The received by attribute of that proxy.
     */
    protected static int ATTR_RECEIVED_BY = -1;

    static {
	Attribute a = null;
	Class     c = null;
	try {
	    c = Class.forName("w3c.jigsaw.proxy.ForwardDirectory");
	} catch (Exception ex) {
	    ex.printStackTrace();
	    System.exit(1);
	}
	// Declare the local root attribute:
	a = new StringAttribute("local-root"
				, null
				, Attribute.EDITABLE);
	ATTR_LOCAL_ROOT = AttributeRegistry.registerAttribute(c, a);
	// Declare the received by attribute:
	a = new StringAttribute("received-by"
				, null
				, Attribute.EDITABLE);
	ATTR_RECEIVED_BY = AttributeRegistry.registerAttribute(c, a);
    }

    private static final String nocache[] = { };

    /**
     * Get the local root resource name.
     */

    public String getLocalRoot() {
	return getString(ATTR_LOCAL_ROOT, null);
    }

    /**
     * Get the received by attribute value.
     * <p>If this attribute is not defined, it will default to the name of the
     * host running the proxy.
     * @return A String.
     */

    public String getReceivedBy() {
	String value = getString(ATTR_RECEIVED_BY, null);
	if ( value == null )
	    value = getServer().getHost();
	return value;
    }

    /**
     * Get the value of the <code>via</code> header to be added.
     * @return A String encoded value for the header.
     */

    private String via = null;
    public synchronized String getVia() {
	if ( via == null ) 
	    via = "1.1 "+getReceivedBy()+" ("+getServer().getSoftware()+")";
	return via;
    }

    /**
     * Get the local root resource to use for internal requests.
     */

    protected HTTPResource lroot = null;
    public synchronized HTTPResource getLocalRootResource() {
	if ( lroot == null ) {
	    String lname = getLocalRoot();
	    if ( lname != null ) 
		lroot = getServer().loadResource(lname);
	}
	return lroot;
    }

    /**
     * Duplicate a server side request into a client side request.
     * @param request The server side request.
     * @return A Client side request.
     */

    protected w3c.www.protocol.http.Request dupRequest(Request request) 
	throws HTTPException, IOException
    {
	w3c.www.protocol.http.HttpManager man = null;
	w3c.www.protocol.http.Request     req = null;
	String                            mth = request.getMethod();
	// Create a client request, and initialize its target & method:
	man = w3c.www.protocol.http.HttpManager.getManager();
	req = man.createRequest();
	req.setURL(request.getURL());
	req.setMethod(mth);
	// If this is a two stage method, setup an observer:
	if ((request.getMajorVersion() >= 1)
	    && (request.getMinorVersion() >= 1)
	    && (mth.equals("PUT") || mth.equals("POST"))) 
	    req.setObserver(new ProxyRequestObserver(request));
	// Update the client request fields:
	Enumeration e = request.enumerateHeaderDescriptions();
	while ( e.hasMoreElements() ) {
	    HeaderDescription d = (HeaderDescription) e.nextElement();
	    HeaderValue       v = request.getHeaderValue(d);
	    if ( v != null )
		req.setHeaderValue(d, v);
	}
	// Get rid of all hop-by-hop headers:
	req.setHeaderValue(Reply.H_CONNECTION, null);
	req.setHeaderValue(Reply.H_PROXY_CONNECTION, null);
	req.setHeaderValue(Reply.H_PUBLIC, null);
	req.setHeaderValue(Reply.H_PROXY_AUTHENTICATE, null);
	req.setHeaderValue(Reply.H_TRANSFER_ENCODING, null);
	req.setHeaderValue(Reply.H_UPGRADE, null);
	req.removeHeader("keep-alive");
	// Get rid of more hop by hop headers:
	String conn[] = request.getConnection();
	if ( conn != null ) {
	    for (int i = 0 ; i < conn.length ; i++) 
		req.removeHeader(conn[i]);
	}
	// Fix versions mismatches:
	if ( request.hasPragma("no-cache") )
	    req.setNoCache(nocache);
	// Add the via clause:
	req.addVia(getVia());
	// Update the request output stream:
	req.setOutputStream(request.getInputStream());
	return req;
    }

    // FIXME

    protected Reply dupReply(Request request
			     , w3c.www.protocol.http.Reply rep) 
	throws HTTPException, IOException
    {
	Reply reply = request.makeReply(rep.getStatus());
	// Duplicate reply header values:
	Enumeration e = rep.enumerateHeaderDescriptions();
	while ( e.hasMoreElements() ) {
	    HeaderDescription d = (HeaderDescription) e.nextElement();
	    HeaderValue       v = rep.getHeaderValue(d);
	    if ( v != null )
		reply.setHeaderValue(d, v);
	}
	// Get rid of hop by hop headers:
	rep.setHeaderValue(Reply.H_CONNECTION, null);
	rep.setHeaderValue(Reply.H_PROXY_CONNECTION, null);
	rep.setHeaderValue(Reply.H_PUBLIC, null);
	rep.setHeaderValue(Reply.H_TRANSFER_ENCODING, null);
	rep.setHeaderValue(Reply.H_UPGRADE, null);
	rep.removeHeader("keep-alive");
	// Get rid of the fields enumerated in the connection header:
	String conn[] = rep.getConnection();
	if (conn != null) {
	    for (int i = 0 ; i < conn.length ; i++) 
		reply.removeHeader(conn[i]);
	}
	// Update the via route:
	reply.addVia(getVia());
	// Update the reply output stream:
	reply.setStream(rep.getInputStream());
	reply.setProxy(true);
	return reply;
    }

    /**
     * Perform the given proxied request.
     * @param request The request to perform.
     * @param filters The set of filters to apply.
     * @return A Reply instance.
     */

    public Reply perform(Request request, HTTPFilter filters[]) 
	throws HTTPException, ClientException
    {
	// Apply any ingoing filters before proceeding further:
	Reply reply = null;
	if ( filters != null ) {
	    for (int i = 0 ; i < filters.length ; i++) {
		if ( filters[i] == null )
		    continue;
		reply = filters[i].ingoingFilter(request, filters, i);
		if ( reply != null )
		    return reply;
	    }
	}
	// Perform the request:
	try {
	    w3c.www.protocol.http.Request     req = dupRequest(request);
	    w3c.www.protocol.http.Reply       rep = null;
	    w3c.www.protocol.http.HttpManager man = null;
	    man = w3c.www.protocol.http.HttpManager.getManager(); 
	    // Perform the request
	    rep = man.runRequest(req);
	    // Dump back the client reply into a server reply:
	    reply = dupReply(request, rep);
	} catch (Exception ex) {
	    if ( debug ) {
		System.out.println("Exception while running request:");
		ex.printStackTrace();
	    }
	    reply = request.makeReply(HTTP.GATEWAY_TIMEOUT);
	    reply.setContent("An HTTP error occured while getting "
			     + request.getURL()
			     + ".<p>Details \""+ex.getMessage()+"\".");
	}
	// Apply any outgoing filters now that we are done:
	if ( filters != null ) {
	    Reply fr = null;
	    for (int i = filters.length ; --i >= 0 ; ) {
		if ( filters[i] == null )
		    continue;
		fr = filters[i].outgoingFilter(request, reply, filters, i);
		if ( fr != null )
		    return fr;
	    }
	}
	return reply;
    }

    public void initialize(Object values[]) {
	super.initialize(values) ;
	synchronized(this.getClass()) {
	    if (!inited) {
		// Register the client side properties (if still needed):
		httpd server = getServer();
		server.registerPropertySet(new ProxyProp("proxy", server));
		server.registerPropertySet(new CacheProp("cache", server));
		// Make sure the cache get some correct default directory:
		DaemonProperties p = getServer().getProperties();
		File             c = p.getFile(CacheFilter.CACHE_DIRECTORY_P
					       , null);
		if ( c == null ) {
		    c = new File(getServer().getConfigDirectory(), "cache");
		    p.putValue(CacheFilter. CACHE_DIRECTORY_P, c.toString());
		}
		inited = true;
	    }
	}
    }
}
