// MapAttribute.java
// $Id: MapAttribute.java,v 1.5 1996/08/18 19:18:27 anto Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.map ;

import java.io.*;

import w3c.jigsaw.resources.* ;


class MapAttribute extends Attribute {
    private static final byte VALID_MAP = 1;
    private static final byte INVALID_MAP = 0;

    public boolean checkValue(Object obj)
    {
	return (obj == null || obj instanceof Map);
    }

    public void pickle(DataOutputStream out, Object obj)
	throws IOException
    {
	if(obj == null)
	    out.writeByte(INVALID_MAP);
	else {
	    out.writeByte(VALID_MAP);
	    ( (Map) obj ).pickle(out);
	}
    }

    public Object unpickle(DataInputStream in)
	throws IOException 
    {
	byte valid = in.readByte();
	if(valid == VALID_MAP) {
	    Map map = new Map();
	    map.unpickle(in);
	    return map;
	} else return null;
    }

    public MapAttribute(String name, Map def, int flags) 
    {
	super(name,def,flags);
    }
}

