// httpdStatistics.java
// $Id: httpdStatistics.java,v 1.5 1996/09/25 14:16:17 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.http;

import java.net.*;

/**
 * This class maintains server wide statistics about hits.
 * This class should probably be coded as a resource itself, and made 
 * accessible through a specific HTTPResource. I am just having fun 
 * for the time being.
 */


public class httpdStatistics {
    protected httpd server = null ;

    /**
     * The min processing time in ms.
     */
    protected long r_min = Long.MAX_VALUE ;
    /**
     * The URL that has been processed the fastest.
     */
    protected URL u_min = null ;
    /**
     * The maximum processing time in ms.
     */
    protected long r_max = 0 ;
    /**
     * The URL that has been processed the slowest.
     */
    protected URL u_max = null ;
    /**
     * The total number of hits.
     */
    protected long t_hits  = 0 ;
    /**
     * The total number of emited bytes.
     */
    protected long t_bytes = 0 ;
    /**
     * The total time spent in processing requests in ms.
     */
    protected long t_req = 0 ;
    /**
     * The date at which the server was started (ms since Java epoch).
     */
    protected long start_time = 0;

    /**
     * Update the current statistics with the given request.
     * @param client The client that processed the request.
     * @param request The request that has been processed.
     * @param nbytes The number of emited bytes in reply's body.
     * @param duration The processing time of the request.
     */

    protected synchronized void updateStatistics(Client client
						 , Request request, Reply reply
						 , int nbytes
						 , long duration) {
	if ( duration > r_max ) {
	    r_max = duration ;
	    u_max = request.getURL() ;
	}
	if ( duration < r_min ) {
	    r_min = duration ;
	    u_min = request.getURL() ;
	}
	t_req   += duration ;
	t_bytes += nbytes ;
	t_hits++ ;
    }

    /**
     * Get the current server load.
     * @return A number between <strong>1</strong> and <strong>4</strong>.
     */

    public int getServerLoad() {
	return server.pool.loadavg;
    }

    /**
     * Get the number of free threads in the server.
     * @return The number of threads ready to server client requests.
     */

    public int getFreeThreadCount() {
	return server.pool.freeCount;
    }

    /**
     * Get the number of idle threads in the server.
     * Idle threads are the threads ready to accept more requests on a given
     * connection.
     * @return The number of idle threads.
     */

    public int getIdleThreadCount() {
	return server.pool.idleCount;
    }

    /**
     * Get the total number of client threads.
     * @return The total number of created threads.
     */

    public int getTotalThreadCount() {
	return server.pool.clientCount;
    }

    /**
     * Get the total number of hits.
     * @return The total number of processed requests since the server is up.
     */
    
    public long getHitCount() {
	return t_hits ;
    }

    /**
     * Get the mean request processing time.
     * @return The average time to process a request.
     */

    public long getMeanRequestTime() {
	return (t_hits > 0) ? t_req / t_hits : -1 ;
    }

    /**
     * Get the max request processing time.
     * @return A long giving the maximum duration for a request.
     */

    public long getMaxRequestTime() {
	return r_max ;
    }

    /**
     * Get the URL of the request that took the longest time to be processed.
     * @return A String giving the URL of the corresponding request, or
     *    <strong>null</strong> if no request has been processed yet.
     */

    public URL getMaxRequestURL() {
	return u_max ;
    }

    /**
     * Get the min request processing time.
     * @return A long giving the minimum request processing time.
     */

    public long getMinRequestTime() {
	return r_min ;
    }

    /**
     * Get the URL of the request that took the smallest time to be processed.
     * @return A String giving the URL of the corresponding request, or
     *    <strong>null</strong> if no request has been processed yet.
     */

    public URL getMinRequestURL() {
	return u_min ;
    }

    /**
     * Get the total number of bytes emited.
     * @return A long giving the total number of bytes emited by the server.
     *    This count that not include the reply's header, but only the reply's
     *    body (or <em>entity</em> size).
     */

    public long getEmittedBytes() {
	return t_bytes ;
    }

    /**
     * Get the time at which the server was started.
     * @return A number of milliseconds since java epoch, giving the date
     * at which the server started.
     */

    public long getStartTime() {
	return start_time;
    }

    httpdStatistics (httpd server) {
	this.server     = server ;
	this.start_time = System.currentTimeMillis();
    }

}
