// LinkField.java
// $Id: LinkField.java,v 1.1 1996/08/09 15:01:51 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.* ;

/**
 * A link field is an imutable field, that allows to insert links into a form.
 */

public class LinkField extends FormField {
    String value = null;

    public Object getValue() {
	return value;
    }

    /**
     * Set this field value.
     * @param nval The new value for this field, as a string.
     * @return A boolean, <strong>true</strong if the field value has changed,
     *    <strong>false</strong> otherwise.
     */

    public boolean setValue (String nval)
	throws FormFieldException
    {
	throw new FormFieldException("LinkField: is immutable.");
    }

    /**
     * Dump this field into a suitable HTML form element.
     * @param into The HtmlGenerator to dump this field into.
     */

    public void dump (HtmlGenerator into) {
	dumpTitle(into);
	into.append("<th align=left><a href=\""+value+"\">"+name+"</a></th>");
    }

    public LinkField(String name, String title, String url, String value) {
	super(name, title, url);
	this.value = value;
    }

    public LinkField() {
    }

}
