// FormFieldInterface.java
// $Id: FormFieldInterface.java,v 1.2 1996/08/12 17:09:35 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.* ;

public interface FormFieldInterface {

    /**
     * Get this field name.
     */

    abstract
    public String getName() ;

    /**
     * Get this field value.
     */

    abstract
    public Object getValue() ;

    /**
     * Set this field value.
     * @param nval The new value for this field, as a string.
     * @return A boolean, <strong>true</strong if the field value has changed,
     *    <strong>false</strong> otherwise.
     */

    abstract
    public boolean setValue (String nval) throws FormFieldException;

    /**
     * Dump this field into a suitable HTML form element.
     * @param into The HtmlGenerator to dump this field into.
     */

    abstract
    public void dump (HtmlGenerator into) ;

    /**
     * Form field may be automatically instanciated, initialize such a field.
     * As form field may be created through the FormFieldRegistry (or
     * someday through the AppletFieldRegistry), they have to be dynamically
     * instanciated and initialized.
     * <p>This method provides support for the initialization stage.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */

    abstract 
    public void initialize(String name, String title, String url, Object val)
	throws FormFieldException ;

}
