// FormField.java
// $Id: FormField.java,v 1.2 1996/09/10 21:30:58 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.forms ;

import w3c.jigsaw.html.HtmlGenerator ;

abstract public class FormField implements FormFieldInterface {
    private static String pad    = "                                " ;
    private static int    PADLEN = pad.length() ;

    private String urlWindow = null;

    String     name  = null ;
    String     title = null ;
    String     url   = null ;

    /**
     * Get this field's name.
     * @return The field name.
     */

    public String getName() {
	return name ;
    }

    /**
     * Get the field's title.
     * @return The field's title.
     */

    public String getTitle() {
	return title ;
    }

    /**
     * Set the target window name of the URL, if any.
     * @param wname The window name.
     */

    public void setURLWindowName(String urlWindow) {
	this.urlWindow = urlWindow;
    }

    /**
     * Dump this field title.
     */

    protected void dumpTitle (HtmlGenerator into) {
	int len = title.length() ;
	if ( url != null ) {
	    into.append ("<tr><th align=right><p>"
			 + "<a href=\""
                         + url
			 + ((urlWindow != null)
			    ? "\" target=\""+urlWindow+"\""
			    : "\"")
			 +"\">"
			 + title
			 + "</a>"
			 + ":"
			 + ((len<PADLEN) ? pad.substring(0, PADLEN-len) : "")
			 + "</th>");
	} else {
	    into.append ("<tr><th align=right><p>"
			 + title
			 + ":"
			 + ((len<PADLEN) ? pad.substring(0, PADLEN-len) : "")
			 + "</th>");
	}
    }

    /*
     * Initialize a FormField.
     * @param name The name of the field.
     * @param title Its title.
     * @param url Its url (or <strong>null</strong>).
     * @param value Its default value.
     * @exception FormFieldException If the provided value doesn't match 
     *    the expected type.
     */
    
    public void initialize(String name, String title, String url, Object val) 
	throws FormFieldException
    {
	this.name  = name ;
	this.title = title ;
	this.url   = url ;
    }

    /**
     * Create a new field.
     * @param form The form to which this field belongs.
     * @param name The fields name (should be uniq among the same form).
     * @param title The fields title.
     */

    public FormField (String name, String title, String url) {
	this.name  = name ;
	this.title = title ;
	this.url   = url ;
    }

    /**
     * This construcotr is to be used along with the initialize interface.
     */

    public FormField() {
    }

}
