// DebugFilter.java
// $Id: DebugFilter.java,v 1.5 1996/09/18 14:30:36 abaird Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package w3c.jigsaw.filters;

import java.io.*;

import w3c.jigsaw.http.*;
import w3c.jigsaw.resources.*;

/**
 * Print incoming request and outgoing replies.
 */


public class DebugFilter extends ResourceFilter {
    /**
     * Attribute index - The on/off toggle.
     */
    protected static int ATTR_ONOFF = -1 ;

    static {
	Attribute a   = null ;
	Class     cls = null ;
	try {
	    cls = Class.forName("w3c.jigsaw.filters.DebugFilter");
	} catch (Exception ex) {
	    ex.printStackTrace() ;
	    System.exit(1) ;
	}
	// The onoff toggle
	a = new BooleanAttribute("onoff"
				 , Boolean.TRUE
				 , Attribute.EDITABLE) ;
	ATTR_ONOFF = AttributeRegistry.registerAttribute(cls, a) ;
    }

    /**
     * Get the onoff toggle value.
     */

    public boolean getOnOffFlag() {
	return getBoolean(ATTR_ONOFF, true) ;
    }

    /**
     * The ingoing filter - fearly easy !
     * @param request The incomming request.
     * @return Always <strong>null</strong>.
     */

    public Reply ingoingFilter(Request request) {
	if ( getOnOffFlag() ) 
	    request.dump(System.out);
	return null;
    }

    /**
     * The outgoing filter - As easy as the ingoing filter.
     * @param request The original request.
     * @param reply The target's reply.
     * @exception HTTPException If processing failed.
     */

    public Reply outgoingFilter(Request request, Reply reply) {
	if ( getOnOffFlag() ) 
	    reply.dump(System.out);
	return null ;
    }

}

