] /*                                                       HTStyle: Style management for libwww <                               STYLE DEFINITION FOR HYPERTEXT-                                               U    Styles allow the translation between a logical property of a piece of text and its     physical representation.      Z    A StyleSheet is a collection of styles, defining the translation necessary to represent-    a document. It is a linked list of styles.       Overriding this module  Z    Why is the style structure declared in the HTStyle.h module, instead of having the userX    browser define the structure, and the HTStyle routines just use sizeof() for copying?     X    It's not obvious whether HTStyle.c should be common code.  It's useful to have commonY    code for loading style sheets, especially if the movement toward standard style sheets     gets going.     S    If it IS common code, then both the hypertext object and HTStyle.c must know the X    structure of a style, so HTStyle.h is a suitable place to put that.  HTStyle.c has to&    be compiled with a knowledge of the     S    It we take it out of the library, then of course HTStyle could be declared as an V    undefined structure. The only references to it are in the structure-flattening code7    HTML.c and HTPlain.c, which only use HTStypeNamed().      V    You can in any case override this function in your own code, which will prevent theX    HTStyle from being loaded.  You will be able to redefine your style structure in this=    case without problems, as no other moule needs to know it.        */    #ifndef GridStyle_H  #define GridStyle_H   2 #include "HTStyle.h"           /* Portable bits */         typedef float HTCoord;   #ifdef OLD_CODE " typedef struct _HTParagraphStyle {?     HTCoord     left_indent;            /* @@@@ junk! etc etc*/  } HTParagraphStyle;  #endif  B typedef int HTColor;            /* Sorry about the US spelling! */       typedef struct {H     short               kind;           /* only NX_LEFTTAB implemented*/C     HTCoord             position;       /* x coordinate for stop */  } HTTabStop;              9 #define STYLE_NAME_LENGTH       80      /* @@@@@@@@@@@ */             /*      The Style Structure  **      -------------------  */   struct _HTStyle {   $ /*      Style management information */N     struct _HTStyle     *next;          /* Link for putting into stylesheet */8     char *              name;           /* Style name */?     char *              SGMLTag;        /* Tag name to start */     , /*      Character attributes    (a la NXRun) */5     HTFont              font;           /* Font id */ O     HTCoord             fontSize;       /* The size of font, not independent */ >     HTColor             color;  /* text gray of current run */J     int                 superscript;    /* superscript (-sub) in points */  I     HTAnchor            *anchor;        /* Anchor id if any, else zero */   2 /*      Paragraph Attribtes     (a la NXTextStyle) */M     HTCoord             indent1st;      /* how far first line in paragraph is .                                  * indented */M     HTCoord             leftIndent;     /* how far second line is indented */ H     HTCoord             rightIndent;    /* (Missing from NeXT version */@     short               alignment;      /* quad justification */9     HTCoord             lineHt;         /* line height */ L     HTCoord             descentLine;    /* descender bottom from baseline */N     HTTabStop           *tabs;          /* array of tab stops, 0 terminated */  N     BOOL                wordWrap;       /* Yes means wrap at space not char */N     BOOL                freeFormat;     /* Yes means \n is just white space */H     HTCoord             spaceBefore;    /* Omissions from NXTextStyle */#     HTCoord             spaceAfter; O     int                 paraFlags;      /* Paragraph flags, bits as follows: */   M #define PARA_KEEP       1       /* Do not break page within this paragraph */ L #define PARA_WITH_NEXT  2       /* Do not break page after this paragraph */  3 #define HT_JUSTIFY 0            /* For alignment */  #define HT_LEFT 1  #define HT_RIGHT 2 #define HT_CENTER 3    };   #ifdef NOT_IN_GRIDSTYLE    /*   Style Creation     HTSTYLEMODIFY    X    This routine is passed the style for a particular SGML nesting state, and the elementW    number of a new element whithin that state. The routine returns a suitable style for Z    text within the new element. It is passed a popinter tothe nesting state so that it canV    link the style back to the nesting state for later manipulation of the SGML nesting    tree.       */     ' extern HTStyle * HTStyleModify PARAMS(( &                 HTStyle *       style,(                 HTNesting*      nesting,1                 int             element_number));        /*      Style functions: */% extern HTStyle * HTStyleNew NOPARAMS; = extern HTStyle* HTStyleNewNamed PARAMS ((CONST char * name)); 6 extern HTStyle * HTStyleFree PARAMS((HTStyle * self)); #ifdef SUPRESSI extern HTStyle * HTStyleRead PARAMS((HTStyle * self, HTStream * stream)); J extern HTStyle * HTStyleWrite PARAMS((HTStyle * self, HTStream * stream)); #endif /*              Style Sheet  **              -----------  */ typedef struct _HTStyleSheet {         char *          name;          HTStyle *       styles;  } HTStyleSheet;      /*      Stylesheet functions:  *// extern HTStyleSheet * HTStyleSheetNew NOPARAMS; E extern HTStyleSheet * HTStyleSheetFree PARAMS((HTStyleSheet * self)); O extern HTStyle * HTStyleNamed PARAMS((HTStyleSheet * self, CONST char * name)); O extern HTStyle * HTStyleMatching PARAMS((HTStyleSheet *self, HTStyle * style)); O /* extern HTStyle * HTStyleForRun PARAMS((HTStyleSheet *self, NXRun * run)); */ G extern HTStyleSheet * HTStyleSheetAddStyle PARAMS((HTStyleSheet * self,          HTStyle * style));J extern HTStyleSheet * HTStyleSheetRemoveStyle PARAMS((HTStyleSheet * self,         HTStyle * style)); #ifdef SUPPRESS C extern HTStyleSheet * HTStyleSheetRead PARAMS((HTStyleSheet * self, D                                                 HTStream * stream));D extern HTStyleSheet * HTStyleSheetWrite PARAMS((HTStyleSheet * self,D                                                 HTStream * stream)); #endifL #define CLEAR_POINTER ((void *)-1)      /* Pointer value means "clear me" */   #endif /* NOT IN GRIDSTYLE */  #endif /* GRIDSTYLE_H */     /*       */