= /*	WorldWideWeb - Wide Area Informaion Server Access	HTWAIS.c 5 **	==================================================  **@ **	This module allows a WWW server or client to read data from a **	remote  WAIS D **  server, and provide that data to a WWW client in hypertext form.@ **  Source files, once retrieved, are stored and used to provide5 **  information about the index when that is acessed.  **
 ** Authors= **	BK	Brewster Kahle, Thinking Machines, <Brewster@think.com> 1 **	TBL	Tim Berners-Lee, CERN <timbl@info.cern.ch>  **
 ** HistoryD **	   Sep 91	TBL adapted shell-ui.c (BK) with HTRetrieve.c from WWW.C **	   Feb 91	TBL Generated HTML cleaned up a bit (quotes, escaping) % **			    Refers to lists of sources.  3 **	   Mar 93	TBL   Lib 2.0 compatible module made.	  ** ** Bugs @ **	Uses C stream i/o to read and write sockets, which won't work **	on VMS TCP systems. ** **	Should cache connections. ** **	ANSI C only as written  **
 ** Bugs fixed : **      NT Nathan Torkington (Nathan.Torkington@vuw.ac.nz) ** ** WAIS comments:  **? **	1.	Separate directories for different system's .o would help # **	2.	Document ids are rather long!  **" ** WWW Address mapping convention: **/ **	/servername/database/type/length/document-id  **& **	/servername/database?word+word+word */) /* WIDE AREA INFORMATION SERVER SOFTWARE: L    No guarantees or restrictions.  See the readme file for the full standard    disclaimer.      Brewster@think.com  */    7 #define DIRECTORY "/cnidr.org:210/directory-of-servers" B /* define DIRECTORY "/quake.think.com:210/directory-of-servers" */  3 #define BIG 1024	/* identifier size limit  @@@@@ */    /*			From WAIS **			--------- */   #include <ui.h>    #define MAX_MESSAGE_LEN 100000L #define CHARS_PER_PAGE 10000 /* number of chars retrieved in each request */) #define WAISSEARCH_DATE "Fri Jul 19 1991"     
 /*			FROM WWW 
 **			--------  */< #define BUFFER_SIZE 4096	/* Arbitrary size for efficiency */   #define HEX_ESCAPE '%'   #include "HTUtils.h" #include "tcp.h" #include "HTParse.h"4 #include "HTAccess.h"		/* We implement a protocol */ #include "HTError.h"4 #include "HTML.h"		/* The object we will generate */    /* #include "ParseWSRC.h" */  9 extern int WWW_TraceFlag;	/* Control diagnostic output */ - extern FILE * logfile;		/* Log file output */   I PUBLIC int HTMaxWAISLines = 100;/* Max number of entries from a search */   9 PRIVATE BOOL	as_gate;	/* Client is using us as gateway */   > PRIVATE char	line[2048];	/* For building strings to display */! 				/* Must be able to take id */      #include "HTParse.h" #include "HTFormat.h"  #include "HTTCP.h"8 /* #include "HTWSRC.h"	*/	/* Need some bits from here */  ' /*		Hypertext object building machinery  */ #include "HTML.h"   8 #define PUTC(c) (*target->isa->put_character)(target, c)5 #define PUTS(s) (*target->isa->put_string)(target, s) ? #define START(e) (*target->isa->start_element)(target, e, 0, 0) 5 #define END(e) (*target->isa->end_element)(target, e) 0 #define FREE_TARGET (*target->isa->free)(target)   struct _HTStructured { 	CONST HTStructuredClass *	isa; 
 	/* ... */ };   struct _HTStream { 	CONST HTStreamClass *	isa; 
 	/* ... */ };     /*								showDiags  */6 /* modified from Jonny G's version in ui/question.c */   void showDiags ARGS2(  	HTStream *, 		target, 	diagnosticRecord **, 	d)  { 	   long i;   "   for (i = 0; d[i] != NULL; i++) {      if (d[i]->ADDINFO != NULL) {"       PUTS("Diagnostic code is ");       PUTS(d[i]->DIAG);        PUTC(' ');       PUTS(d[i]->ADDINFO);       PUTC('\n'); ;      }    }  }   , /*	Matrix of allowed characters in filenames, **	----------------------------------------- */   PRIVATE BOOL acceptable[256]; $ PRIVATE BOOL acceptable_inited = NO;  # PRIVATE void init_acceptable NOARGS  {      unsigned int i;      char * good = L       "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./-_$";,     for(i=0; i<256; i++) acceptable[i] = NO;>     for(;*good; good++) acceptable[(unsigned int)*good] = YES;     acceptable_inited = YES; }   - /*	Transform file identifier into WWW address - **	------------------------------------------  ** ** ** On exit,  **	returns		nil if error5 **			pointer to malloced string (must be freed) if ok  */+ char * WWW_from_archie ARGS1 (char *, file)  {      char * end;      char * result;     char * colon; A     for(end=file; *end > ' '; end++);	/* assumes ASCII encoding*/ -     result = (char *)malloc(10 + (end-file)); 3     if (!result) return result;		/* Malloc error */      strcpy(result, "file://");$     strncat(result, file, end-file);@     colon = strchr(result+7, ':');	/* Expect colon after host */     if (colon) {= 	for(; colon[0]; colon[0]=colon[1], colon++);	/* move down */      }      return result; } /* WWW_from_archie */   ) /*	Transform document identifier into URL ) **	--------------------------------------  **0 ** Bugs: A static buffer of finite size is used!( **	The format of the docid MUST be good! ** ** On exit,  **	returns		nil if error5 **			pointer to malloced string (must be freed) if ok  */+ PRIVATE char hex [17] = "0123456789ABCDEF"; ; extern char from_hex PARAMS((char a));			/* In HTWSRC @@ */   0 PRIVATE char * WWW_from_WAIS ARGS1(any *, docid)   { "     static unsigned char buf[BIG];     char num[10];      unsigned char * q = buf;     char * p = (docid->bytes);
     int i, l;      if (TRACE) {	 	char *p; E 	fprintf(stderr, "HTLoadWAIS.. id (%d bytes) is ", (int)docid->size); 7 	for(p=docid->bytes; p<docid->bytes+docid->size; p++) { 7 	    if ((*p >= ' ') && (*p<= '~')) /* Assume ASCII! */  		fprintf(stderr, "%c", *p);	 	    else ( 		fprintf(stderr, "<%x>", (unsigned)*p); 	} 	fprintf(stderr, "\n");      }	  J     for (p=docid->bytes; (p<docid->bytes+docid->size) && (q<&buf[BIG]);) {G 	if (TRACE) fprintf(stderr, "............ Record type %d, length %d\n", 2 			   (unsigned char) p[0], (unsigned char) p[1]); 	sprintf(num, "%d", (int)*p);  	memcpy(q, num, strlen(num));  	q += strlen(num); 	p++;  	*q++ = '=';		/* Separate */ 	l = (int)((unsigned char)*p); 	p++; 
 	if (l > 127)  	    { 		l = (l - 128) * 128;# 		l = l + (int)((unsigned char)*p);  		p++; 	    } 	  	for (i = 0; i < l; i++, p++)  	    {& 		if (!acceptable[(unsigned char)*p])  		    {  			*q++ = HEX_ESCAPE; ( 			*q++ = hex[((unsigned char)*p) >> 4];( 			*q++ = hex[((unsigned char)*p) & 15]; 		    }   		else *q++ = (unsigned char)*p; 	    }" 	*q++= ';';		/* Terminate field */ #ifdef OLD_CODE          if (*p>10) { 	    if (TRACE) A 		fprintf(stderr, "WAIS........ DOCID record type of %d!\n", *p);  	    return 0; 	}2 	{	/* Bug fix -- allow any byte value 15 Apr 93 */& 	    unsigned int i = (unsigned) *p++; 	      	    if (i > 99) { 		*q++ = (i/100) + '0';  		i = i % 100; 	    } 	    if (i > 9) {  		*q++ = (i/10) + '0';
 		i = i % 10;  	    }& 	    *q++ = i + '0';	/* Record type */ 	} 	*q++ = '=';		/* Separate */ 	l = *p++;		/* Length */ 	for(i=0; i<l; i++, p++){   	    if (!acceptable[(int)*p]) {- 		*q++ = HEX_ESCAPE;	/* Means hex commming */  		*q++ = hex[(*p) >> 4]; 		*q++ = hex[(*p) & 15]; 	    } 	    else *q++ = *p; 	}" 	*q++= ';';		/* Terminate field */ #endif /* OLD_CODE */      } &     *q++ = 0;			/* Terminate string */J     if (TRACE) fprintf(stderr, "HTLoadWAIS.. WWW form of id: %s\n", buf);      { 6         char * result = (char *)malloc(strlen(buf)+1); 	strcpy(result, buf);  	return result;      }  } /* WWW_from_WAIS */     . /*	Transform URL into WAIS document identifier. **	------------------------------------------- ** ** On entry,7 **	docname		points to valid name produced originally by  **			WWW_from_WAIS ** On exit,  **	docid->size	is valid 4 **	docid->bytes	is malloced and must later be freed. */A PRIVATE any * WAIS_from_WWW ARGS2 (any *, docid, char *, docname)  { "     char *z; 	/* Output pointer */<     char *sor;	/* Start of record - points to size field. */!     char *p; 	/* Input pointer */ $     char *q; 	/* Poisition of "=" */)     char *s; 	/* Position of semicolon */      int n;	/* size */ Z     if (TRACE) fprintf(stderr, "HTLoadWAIS.. WWW id (to become WAIS id): %s\n", docname); A     for(n=0, p = docname; *p; p++) {	/* Count sizes of strings */          n++;* 	if (*p == ';')  n--;		/* Not converted */7 	else if (*p == HEX_ESCAPE) n=n-2;	/* Save two bytes */          docid->size = n;     }      G     docid->bytes = (char *) malloc(docid->size+32); /* result record */      z = docid->bytes;           for(p = docname; *p; ) { 	q = strchr(p, '=');	 	if (!q)   	    return 0; 	*q = '\0';  	*z++ = atoi(p);
 	*q = '=';' 	s = strchr(q, ';');	/* (Check only) */ 	 	if (!s)  ! 	    return 0;	/* Bad! No ';';	*/ : 	sor = z;          /* Remember where the size field was */1 	z++;              /* Skip record size for now */  	  	{
 	    int len; 
 	    int tmp;  	    for(p=q+1; *p!=';' ; ) {  		if (*p == HEX_ESCAPE) { 
 		    char c;  		    unsigned int b; 
 		    p++; 		    c = *p++;  		    b = from_hex(c); 		    c = *p++;  		    if (!c) $ 			break;	/* Odd number of chars! */" 		    *z++ = (b<<4) + from_hex(c);
 		} else { 		    *z++ = *p++;	/* Record */  		}  	    } 	    len = (z-sor-1);  	     
 	    z = sor;  	    if (len > 127) {  		tmp = (len / 128); 		len = len - (tmp * 128); 		tmp = tmp + 128; 		*z++ = (char)tmp;  		*z = (char)len; 
 	    } else {  		*z = (char)len;  	    }	 	    z++;  	} 	  	for(p=q+1; *p!=';' ; )  { 	    if (*p == HEX_ESCAPE) {	 		char c;  		unsigned int b;  		p++; 		c = *p++;  		b = from_hex(c); 		c = *p++; 
 		if (!c) ' 		    break;	/* Odd number of chars! */  		*z++ = (b<<4) + from_hex(c);
 	    } else {  		*z++ = *p++;	/* Record */  	    } 	}3 	p++;			/* After semicolon: start of next record */      }    #ifdef OLD_CODE 5     for(p = docname; *p; ) {	/* Convert of strings */      				/* Record type */  				' 	*z = 0;			/* Initialize record type */ ! 	while (*p >= '0' && *p <= '9') { @ 	    *z = *z*10 + (*p++ - '0');	/* Decode decimal record type */ 	} 	z++;  	if (*p != '=') return 0;  	q = p;  	  /*        *z++ = *p++ - '0'; 	q = strchr(p , '=');  	if (!q) return 0; */' 	s = strchr(q, ';');	/* (Check only) */ % 	if (!s) return 0;	/* Bad! No ';';	*/ 9         sor = z;		/* Remember where the size field was */ & 	z++;			/* Skip record size for now	*/ 	for(p=q+1; *p!=';' ; ) {  	   if (*p == HEX_ESCAPE) {  	        char c; 		unsigned int b;  		p++; 	        c = *p++; 		b =   from_hex(c); 		c = *p++; + 		if (!c) break;	/* Odd number of chars! */  		*z++ = (b<<4) + from_hex(c);
 	    } else { " 	        *z++ = *p++;	/* Record */ 	    } 	}A 	*sor = (z-sor-1);	/* Fill in size -- not counting size itself */ 3 	p++;			/* After semicolon: start of next record */      }  #endif /* OLD_CODE */      if (TRACE) {	 	char *p; E 	fprintf(stderr, "WAIS........ id (%d bytes) is ", (int)docid->size); 7 	for(p=docid->bytes; p<docid->bytes+docid->size; p++) { 7 	    if ((*p >= ' ') && (*p<= '~')) /* Assume ASCII! */  		fprintf(stderr, "%c", *p);	 	    else ( 		fprintf(stderr, "<%x>", (unsigned)*p); 	} 	fprintf(stderr, "\n");      }	       return docid;		/* Ok */       } /* WAIS_from_WWW */     ? /*	Send a plain text record to the client		output_text_record() ) **	--------------------------------------  */  & PRIVATE void output_text_record ARGS4(     HTStream *,			target,       WAISDocumentText *,		record,#     boolean,			quote_string_quotes, '     boolean,                    binary)  { 
   long count;    /* printf(" Text\n"); 9      print_any("     DocumentID:  ", record->DocumentID); @      printf("     VersionNumber:  %d\n", record->VersionNumber);      */      if (binary) { %     (*target->isa->put_block)(target, % 			      record->DocumentText->bytes, % 			      record->DocumentText->size);      return;    }   >   for(count = 0; count < record->DocumentText->size; count++){@     long ch = (unsigned char)record->DocumentText->bytes[count];2     if (ch == 27) {	/* What is this in for? Tim */  & 	    /* then we have an escape code */D 	    /* if the next letter is '(' or ')', then ignore two letters */8 	    if('(' == record->DocumentText->bytes[count + 1] ||0 		')' == record->DocumentText->bytes[count + 1])6 	    count += 1;             /* it is a term marker */5 	    else count += 4;		/* it is a paragraph marker */ *     } else if (ch == '\n' || ch == '\r') { 	    PUTC('\n');*     } else if ((ch=='\t') || isprint(ch)){ 	    PUTC(ch);     }    }  } /* output text record */      C /*	Format A Search response for the client		display_search_response * **	--------------------------------------- */0 /* modified from tracy shen's version in wutil.c7  * displays either a text record or a set of headlines.   */  void display_search_response ARGS4(     HTStructured *,		target,#     SearchResponseAPDU *,	response,      char *,			database,      char *,	 		keywords) {    WAISSearchResponse  *info;   long i, k;   G   BOOL archie =  strstr(database, "archie")!=0;	/* Specical handling */    J   if (TRACE) fprintf(stderr, "WAIS........ Displaying search response\n");   sprintf(line, C 	  "Index %s contains the following %d item%s relevant to '%s'.\n",  	  database,, 	  (int)(response->NumberOfRecordsReturned),4 	  response->NumberOfRecordsReturned ==1 ? "" : "s",
 	  keywords); 
   PUTS(line); B   PUTS("The first figure for each entry is its relative score, ");6   PUTS("the second the number of lines in the item.");   START(HTML_MENU);   3   if ( response->DatabaseDiagnosticRecords != 0 ) { E     info = (WAISSearchResponse *)response->DatabaseDiagnosticRecords; 
     i =0;   "     if (info->Diagnostics != NULL)6       showDiags((HTStream*)target, info->Diagnostics);  "     if ( info->DocHeaders != 0 ) {1       for (k=0; info->DocHeaders[k] != 0; k++ ) { 0 	WAISDocumentHeader* head = info->DocHeaders[k];- 	char * headline = trim_junk(head->Headline);   	any * docid = head->DocumentID;3 	char * docname;			/* printable version of docid */  	i++;   2 /*	Make a printable string out of the document id. */ 	if (TRACE) fprintf(stderr, 3 		"HTWAIS:  %2ld: Score: %4ld, lines:%4ld '%s'\n",  
 	       i,/ 	       (long int)(info->DocHeaders[k]->Score), / 	       (long int)(info->DocHeaders[k]->Lines),  	       headline);   	START(HTML_LI); 	sprintf(line, "%4ld  %4ld  ", 	    head->Score,  	    head->Lines);
 	PUTS( line);    	if (archie) {1 	    char * www_name = WWW_from_archie(headline);  	    if (www_name) {( 		HTStartAnchor(target, NULL, www_name); 		PUTS(headline);  		 		END(HTML_A); 		free(www_name); 
 	    } else {  		 PUTS(headline); 		 PUTS(" (bad file name)"); 	    } 	} else { /* Not archie */% 	    docname =  WWW_from_WAIS(docid);  	    if (docname) { 3 		char * dbname = HTEscape(database, URL_XPALPHAS); 1                 char types_array[1000]; /* bad */ #                 char *type_escaped; #                 types_array[0] = 0; "                 if (head->Types) {                     int i;4                     for (i = 0; head->Types[i]; i++)                       {                          if (i)4                           strcat (types_array, ",");  N                         type_escaped = HTEscape (head->Types[i], URL_XALPHAS);;                         strcat (types_array, type_escaped); ,                         free (type_escaped);                       }                      if (TRACE)]                       fprintf (stderr, "WAIS........ Built types_array '%s'\n", types_array); 
 		} else {1                     strcat (types_array, "TEXT");  		}  		sprintf(line, "%s/%s/%d/%s",                         dbname, $                         types_array,4                         (int)(head->DocumentLength),!                         docname);  #ifdef OLD_CODE 0 		sprintf(line, "%s/%s/%d/%s",		/* W3 address */ 				    dbname, , 		    head->Types ? head->Types[0] : "TEXT"," 		    (int)(head->DocumentLength), 		    docname);  #endif /* OLD_CODE */ . 		HTStartAnchor(target, NULL, ( (head->Types) / 		      && (!strcmp(head->Types[0], "URL"))) ?  + 			      headline : line); /* NT, Sep 93 */  		PUTS(headline);  		END(HTML_A); 		free(dbname);  		free(docname);
 	    } else {  		 PUTS("(bad doc id)"); 	    } 	  }"       } /* next document header */.     } /* if there were any document headers */     $     if ( info->ShortHeaders != 0 ) {       k =0; +       while (info->ShortHeaders[k] != 0 ) {  	i++; / 	PUTS( "(Short Header record, can't display)");        }      } #     if ( info->LongHeaders != 0 ) {        k =0; )       while (info->LongHeaders[k] != 0) {  	i++; 0 	PUTS( "\nLong Header record, can't display\n");       }      }      if ( info->Text != 0 ) {       k =0; "       while (info->Text[k] != 0) { 	i++;  	PUTS( "\nText record\n");F 	output_text_record((HTStream*)target, info->Text[k++], false, false);       }      } !     if ( info->Headlines != 0 ) {        k =0; '       while (info->Headlines[k] != 0) {  	i++; - 	PUTS( "\nHeadline record, can't display\n"); 4 	/* dsply_headline_record( info->Headlines[k++]); */       }      }      if ( info->Codes != 0 ) {        k =0; #       while (info->Codes[k] != 0) {  	i++; ) 	PUTS( "\nCode record, can't display\n"); , 	/* dsply_code_record( info->Codes[k++]); */       }      } $   }				/* Loop: display user info */   END(HTML_MENU);    PUTC('\n'); ;  }         1 /*	Load Document from WAIS Server				HTLoadWAIS() ! **	------------------------------  ** ** On entry,) **	request		This is the request structure  ** On exit, ! **	returns		<0		Error has occured  **			HT_LOADED	OK  */2 PUBLIC int HTLoadWAIS ARGS1(HTRequest * , request)    #define MAX_KEYWORDS_LENGTH 4000 #define MAX_SERVER_LENGTH 1000  #define MAX_DATABASE_LENGTH 1000 #define MAX_SERVICE_LENGTH 1000    { :     CONST char * arg = HTAnchor_physical(request->anchor);2     HTFormat		format_out = request->output_format;-     HTStream*		sink = request->output_stream; 	 #if 0     &     static CONST char * error_header =U "<h1>Access error</h1>\nThe following error occured in accesing a WAIS server:<P>\n";  #endif4     char * key;			  /* pointer to keywords in URL */?     char* request_message = NULL; /* arbitrary message limit */ @     char* response_message = NULL; /* arbitrary message limit */@     long request_buffer_length;	/* how of the request is left */0     SearchResponseAPDU  *retrieval_response = 0;+     char keywords[MAX_KEYWORDS_LENGTH + 1];      char *server_name;	 ?     char *wais_database = NULL;		/* name of current database */ 1     char *www_database;			/* Same name escaped */      char *service;     char *doctype;     char *doclength;     long document_length;      char *docname;     FILE *connection = 0; 4     char * names;		/* Copy of arg to be hacked up */     BOOL ok = NO;      int status = -1;     char *basetitle = NULL;      &     extern FILE * connect_to_server();     .     if (!acceptable_inited) init_acceptable();              , /*	Decipher and check syntax of WWW address:+ **	----------------------------------------  **: **	First we remove the "wais:" if it was spcified.  920110 */  J     names = HTParse(arg, "", PARSE_HOST | PARSE_PATH | PARSE_PUNCTUATION);     key = strchr(names, '?');           if (key) {     	char * p;% 	*key++ = 0;	/* Split off keywords */ . 	for (p=key; *p; p++) if (*p == '+') *p = ' '; 	HTUnEscape(key);      }      if (names[0]== '/') {  	server_name = names+1; & 	if ((as_gate =(*server_name == '/')))+ 	    server_name++;	/* Accept one or two */ ( 	www_database = strchr(server_name,'/'); 	if (www_database) {7 	    *www_database++ = 0;		/* Separate database name */ ) 	    doctype = strchr(www_database, '/'); 4 	    if (key) ok = YES;	/* Don't need doc details */> 	    else if (doctype) {	/* If not search parse doc details */4 		*doctype++ = 0;	/* Separate rest of doc address */# 		doclength = strchr(doctype, '/');  		if(doclength) {  		    *doclength++ = 0; ( 		    document_length = atol(doclength); 		    if (document_length) {" 			docname=strchr(doclength, '/'); 			if (docname) {  			    *docname++ = 0;' 			    ok = YES;	/* To avoid a goto! */  			} /* if docname */ & 		    } /* if document_length valid */ 		} /* if doclength */6 	    } else { /* no doctype?  Assume index required */ 	        if (!key) key = ""; 		ok = YES;  	    } /* if doctype */  	} /* if database */      }            if (!ok) { 	char *unescaped = NULL; 	StrAllocCopy(unescaped, arg); 	HTUnEscape(unescaped); 6 	HTErrorAdd(request, ERR_FATAL, NO, HTERR_BAD_REQUEST,1 		   (void *) unescaped, (int) strlen(unescaped),  		   "HTLoadWAIS");  	free(unescaped); 
 	free(names);  	return -1;      }      ?     if (TRACE) fprintf(stderr, "HTLoadWAIS.. URL Parsed OK\n");        "      service = strchr(names, ':');"      if (service)  *service++ = 0;      else service = "210";             if (server_name[0] == 0)          connection = NULL;        else if (!(key && !*key))O       if ((connection=connect_to_server(server_name,atoi(service))) == NULL)  { - 	  char *host = HTParse(arg, "", PARSE_HOST); \ 	  if (TRACE) fprintf (stderr, "HTLoadWAIS.. Can't open connection to %s via service %s.\n", 			      server_name, service); < 	  HTErrorAdd(request, ERR_FATAL, NO, HTERR_WAIS_NO_CONNECT,8 		     (void *) host, (int) strlen(host), "HTLoadWAIS"); 	  goto cleanup;       }   -     StrAllocCopy(wais_database,www_database);      HTUnEscape(wais_database);  *     /* Make title name without the .src */     {  	char *srcstr;( 	StrAllocCopy(basetitle, wais_database);2 	if ((srcstr = strstr(basetitle, ".src")) != NULL) 	    *srcstr = '\0';     }      1     /* This below fixed size stuff is terrible */ N     request_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));O     response_message = (char*)s_malloc((size_t)MAX_MESSAGE_LEN * sizeof(char));   < /*	If keyword search is performed but there are no keywords,@ **	the user has followed a link to the index itself. It would be= **	appropriate at this point to send him the .SRC file - how?  */  *     if (key && !*key) {				/* I N D E X */      #ifdef CACHE_FILE_PREFIX 	char filename[256]; 	FILE * fp;  #endif0 	HTStructured * target = HTML_new(request, NULL,! 					WWW_HTML, format_out, sink);  	  	{ 	    START(HTML_TITLE);  	    PUTS(basetitle);  	    PUTS(" Index"); 	    END(HTML_TITLE);  	      	    START(HTML_H1); 	    PUTS("WAIS Index: "); 	    PUTS(basetitle);  	    END(HTML_H1); 	      	} 	START(HTML_ISINDEX);   A 	/* If we have seen a source file for this database, use that: */    #ifdef CACHE_FILE_PREFIX- 	sprintf(filename, "%sWSRC-%s:%s:%.100s.txt",  		CACHE_FILE_PREFIX,& 		server_name, service, www_database);  = 	fp = fopen(filename, "r");	/* Have we found this already? */  	if (TRACE) fprintf(stderr, 0 		"HTLoadWAIS.. Description of server %s %s.\n", 		filename, - 		fp ? "exists already" : "does NOT exist!");   
 	if (fp) { 	    char c;5 	    START(HTML_PRE);		/* Preformatted description */ : 	    while((c=getc(fp))!=EOF) PUTC(c);	/* Transfer file */ 	    END(HTML_PRE);  	    fclose(fp); 	} #endif
 	FREE_TARGET;  	 +     } else if (key) {					/* S E A R C H */ 	 	char *p;  	HTStructured * target;  	 - 	strncpy(keywords, key, MAX_KEYWORDS_LENGTH); - 	while ((p = strchr(keywords,'+'))) *p = ' ';      G         /* Send advance title to get something fast to the other end */  	 > 	target = HTML_new(request, NULL, WWW_HTML, format_out, sink); 	  	START(HTML_TITLE);  	PUTS(keywords); 	PUTS(" in "); 	PUTS(basetitle);  	END(HTML_TITLE);  	  	START(HTML_H1); 	PUTS("WAIS Search of \"");  	PUTS(keywords); 	PUTS("\" in "); 	PUTS(basetitle);  	END(HTML_H1);   	START(HTML_ISINDEX);   ; 	request_buffer_length = MAX_MESSAGE_LEN; /* Amount left */ E 	if (TRACE) fprintf(stderr, "HTLoadWAIS.. Search for `%s' in `%s'\n",  		keywords, wais_database); : 	if(generate_search_apdu(request_message + HEADER_LENGTH,  				&request_buffer_length, " 				keywords, wais_database, NULL, 				HTMaxWAISLines) == NULL) {? 	    HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_OVERFLOW,    		       NULL, 0, "HTLoadWAIS"); 	}  ( 	if(!interpret_message(request_message, - 				MAX_MESSAGE_LEN - request_buffer_length,   				response_message,  				MAX_MESSAGE_LEN, 				connection,  				false	/* true verbose */ 				)) {? 	    HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_OVERFLOW,    		       NULL, 0, "HTLoadWAIS");*         } else {	/* returned message ok */- 	    SearchResponseAPDU  *query_response = 0; , 	    readSearchResponseAPDU(&query_response,( 	    	response_message + HEADER_LENGTH);% 	    display_search_response(target,  / 	    	query_response, wais_database, keywords); 3 	    if (query_response->DatabaseDiagnosticRecords)  		freeWAISSearchResponse( 7 			query_response->DatabaseDiagnosticRecords);          - 	    freeSearchResponseAPDU( query_response); ' 	}	/* returned message not too large */      
 	FREE_TARGET;   1     } else {			/* D O C U M E N T    F E T C H */       	HTFormat format_in;< 	boolean binary;     /* how to transfer stuff coming over */ 	HTStream * target;  	long count; 	any   doc_chunk;  	any * docid = &doc_chunk; 	if (TRACE) fprintf(stderr, M 		"HTLoadWAIS.. Retrieve document `%s'\n............ type `%s' length %ld\n", % 		docname, doctype, document_length);  		
 	format_in =  G 	  !strcmp(doctype, "WSRC") ? HTAtom_for("application/x-wais-source") : 8 	  !strcmp(doctype, "TEXT") ? HTAtom_for("text/plain") :7 	  !strcmp(doctype, "HTML") ? HTAtom_for("text/html") : 7 	  !strcmp(doctype, "GIF")  ? HTAtom_for("image/gif") : : 	   		             HTAtom_for("application/octet-stream");
 	binary = " 	  0 != strcmp(doctype, "WSRC") &&" 	  0 != strcmp(doctype, "TEXT") &&! 	  0 != strcmp(doctype, "HTML") ;   @ 	if ((target = HTStreamStack(format_in, request, NO)) == NULL) { 	    status = -1;  	    goto cleanup; 	}  4 	/* Decode hex or litteral format for document ID */ 	WAIS_from_WWW(docid, docname);   ' 	/* Loop over slices of the document */ E 	for (count = 0; count * CHARS_PER_PAGE < document_length; count++) { $ 	    char *type = s_strdup(doctype);E 	    request_buffer_length = MAX_MESSAGE_LEN;	      /* Amount left */ B 	    if (TRACE) fprintf(stderr, "HTLoadWAIS.. Slice number %ld\n", 			       count); A 	    if (generate_retrieval_apdu(request_message + HEADER_LENGTH,  					&request_buffer_length,   					docid, CT_byte, 					count * CHARS_PER_PAGE,( 					HTMIN((count + 1) * CHARS_PER_PAGE, 					      document_length),
 					type, 					wais_database) == 0) { < 		HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_OVERFLOW,  			   NULL, 0, "HTLoadWAIS");  	    } 	    FREE(type); 	     B 	    /* Actually do the transaction given by request_message */   , 	    if (interpret_message(request_message, / 				  MAX_MESSAGE_LEN - request_buffer_length,   				  response_message,  				  MAX_MESSAGE_LEN, 				  connection,  				  false /* true verbose */	  				  ) == 0) { < 		HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_OVERFLOW,  			   NULL, 0, "HTLoadWAIS");  	    } 	     8 	    /* Parse the result which came back into memory. */1 	    readSearchResponseAPDU(&retrieval_response,  ) 				   response_message + HEADER_LENGTH);  	    {g 		WAISSearchResponse *searchres = (WAISSearchResponse *) retrieval_response->DatabaseDiagnosticRecords;  		if (!searchres->Text) { > 		    if (searchres->Diagnostics && *searchres->Diagnostics &&( 			(*searchres->Diagnostics)->ADDINFO) {5 			char *errmsg = (*searchres->Diagnostics)->ADDINFO; : 			HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_MODULE,- 				   (void *) errmsg, (int) strlen(errmsg),  				   "HTLoadWAIS");  		    } else {: 			HTErrorAdd(request, ERR_WARNING, NO, HTERR_WAIS_MODULE, 				   NULL, 0, "HTLoadWAIS"); 		    }  		(*target->isa->free)(target);  		free (docid->bytes);I 		freeWAISSearchResponse(retrieval_response->DatabaseDiagnosticRecords);  . 		freeSearchResponseAPDU( retrieval_response); 		goto cleanup; 
 		} else {2 		    output_text_record(target, *searchres->Text, 				       false, binary); 		} /* If text existed */  	    } 	      	} /* Loop over slices */    	(*target->isa->free)(target);   	free (docid->bytes);  	 I 	freeWAISSearchResponse( retrieval_response->DatabaseDiagnosticRecords);  - 	freeSearchResponseAPDU( retrieval_response);   *     } /* If document rather than search */     status = HT_LOADED;   
   cleanup:1     if (connection) close_connection(connection); +     if (wais_database) free(wais_database); 1     if (request_message) s_free(request_message); 3     if (response_message) s_free(response_message);      FREE(names);     FREE(basetitle);     if (status < 0) {  	char *unescaped = NULL; 	StrAllocCopy(unescaped, arg); 	HTUnEscape(unescaped); G 	HTErrorAdd(request, ERR_FATAL, NO, HTERR_INTERNAL, (void *) unescaped, , 		   (int) strlen(unescaped), "HTLoadWAIS"); 	free(unescaped);      }      return status; }   B GLOBALDEF PUBLIC HTProtocol HTWAIS = { "wais", HTLoadWAIS, NULL };    