1 /*	Style Implementation for Hypertext			HTStyle.c % **	==================================  **: **	Styles allow the translation between a logical property6 **	of a piece of text and its physical representation. **7 **	A StyleSheet is a collection of styles, defining the  **	translation necessary to 7 **	represent a document. It is a linked list of styles.  */ #include "HTStyle.h" #include "HTUtils.h"     /*	Local definition of style **	------------------------- */ /*      The Style Structure  **      -------------------  */   typedef float HTCoord; typedef int HTColor;   typedef struct {H     short               kind;           /* only NX_LEFTTAB implemented*/C     HTCoord             position;       /* x coordinate for stop */  } HTTabStop;     struct _HTStyle {   $ /*      Style management information */N     struct _HTStyle     *next;          /* Link for putting into stylesheet */8     char *              name;           /* Style name */?     char *              SGMLTag;        /* Tag name to start */     , /*      Character attributes    (a la NXRun) */5     HTFont              font;           /* Font id */ O     HTCoord             fontSize;       /* The size of font, not independent */ >     HTColor             color;  /* text gray of current run */J     int                 superscript;    /* superscript (-sub) in points */  I     HTAnchor            *anchor;        /* Anchor id if any, else zero */   2 /*      Paragraph Attribtes     (a la NXTextStyle) */M     HTCoord             indent1st;      /* how far first line in paragraph is .                                  * indented */M     HTCoord             leftIndent;     /* how far second line is indented */ H     HTCoord             rightIndent;    /* (Missing from NeXT version */@     short               alignment;      /* quad justification */9     HTCoord             lineHt;         /* line height */ L     HTCoord             descentLine;    /* descender bottom from baseline */N     HTTabStop           *tabs;          /* array of tab stops, 0 terminated */  N     BOOL                wordWrap;       /* Yes means wrap at space not char */N     BOOL                freeFormat;     /* Yes means \n is just white space */H     HTCoord             spaceBefore;    /* Omissions from NXTextStyle */#     HTCoord             spaceAfter; O     int                 paraFlags;      /* Paragraph flags, bits as follows: */   M #define PARA_KEEP       1       /* Do not break page within this paragraph */ L #define PARA_WITH_NEXT  2       /* Do not break page after this paragraph */  3 #define HT_JUSTIFY 0            /* For alignment */  #define HT_LEFT 1  #define HT_RIGHT 2 #define HT_CENTER 3  };     /*	Create a new style  */! PUBLIC HTStyle* HTStyleNew NOARGS  { 1     return (HTStyle *)calloc(1, sizeof(HTStyle));  }   ! /*	Create a new style with a name  */9 PUBLIC HTStyle* HTStyleNewNamed ARGS1 (CONST char *,name)  { "     HTStyle * self = HTStyleNew();#     StrAllocCopy(self->name, name);      return self; }      /*	Free a style  */3 PUBLIC HTStyle * HTStyleFree ARGS1 (HTStyle *,self)  { %     if (self->name) free(self->name); +     if (self->SGMLTag) free(self->SGMLTag);      free(self); 
     return 0;  }     ' #ifdef SUPPRESS  /* Only on the NeXT */ 0 /*	Read a style from a stream	(without its name) **	--------------------------  **: **	Reads a style with paragraph information from a stream.; **	The style name is not read or written by these routines.  */ #define NONE_STRING "(None)" #define HTStream NXStream   : HTStyle * HTStyleRead (HTStyle * style, HTStream * stream) { "     char myTag[STYLE_NAME_LENGTH];%     char fontName[STYLE_NAME_LENGTH];      NXTextStyle *p;      int	tab;A     int gotpara;		/* flag: have we got a paragraph definition? */  	      NXScanf(stream, "%s%s%f%d",  	myTag, 
 	fontName, 	&style->fontSize, 	&gotpara);      if (gotpara) { 	if (!style->paragraph) { < 	    style->paragraph = malloc(sizeof(*(style->paragraph)));  	    style->paragraph->tabs = 0; 	} 	p = style->paragraph;& 	NXScanf(stream, "%f%f%f%f%hd%f%f%hd", 	    &p->indent1st,  	    &p->indent2nd,  	    &p->lineHt, 	    &p->descentLine,  	    &p->alignment,  	    &style->spaceBefore,  	    &style->spaceAfter, 	    &p->numTabs); 	if (p->tabs) free(p->tabs);3 	p->tabs = malloc(p->numTabs * sizeof(p->tabs[0])); ' 	for (tab=0; tab < p->numTabs; tab++) {  	    NXScanf(stream, "%hd%f",  		    &p->tabs[tab].kind,  		    &p->tabs[tab].x);  	}     } else { /* No paragraph */          if (style->paragraph) {       	    free(style->paragraph);     	    style->paragraph = 0; 	}     } /* if no paragraph */ (     StrAllocCopy(style->SGMLTag, myTag);)     if (strcmp(fontName, NONE_STRING)==0)          style->font = 0;     elseC         style->font = [Font newFont:fontName size:style->fontSize]; 
     return 0;    }     0 /*	Write a style to a stream in a compatible way */; HTStyle * HTStyleWrite (HTStyle * style, NXStream * stream)  {      int tab;&     NXTextStyle *p = style->paragraph;%     NXPrintf(stream, "%s %s %f %d\n",  	style->SGMLTag,0 	style->font ? [style->font name] : NONE_STRING, 	style->fontSize,  	p!=0);        if (p) {1 	NXPrintf(stream, "\t%f %f %f %f %d %f %f\t%d\n",  	    p->indent1st, 	    p->indent2nd, 	    p->lineHt,  	    p->descentLine, 	    p->alignment, 	    style->spaceBefore, 	    style->spaceAfter,  	    p->numTabs);  	     % 	for (tab=0; tab < p->numTabs; tab++) " 	    NXPrintf(stream, "\t%d %f\n", 		    p->tabs[tab].kind, 		    p->tabs[tab].x); 	}     return style;  }     * /*	Write a style to stdout for diagnostics */' HTStyle * HTStyleDump (HTStyle * style)  {      int tab;&     NXTextStyle *p = style->paragraph;:     printf("Style %d `%s' SGML:%s. Font %s %.1f point.\n",     	style, 
 	style->name,  	style->SGMLTag, 	[style->font name], 	style->fontSize);     if (p) {         printf( A     	"\tIndents: first=%.0f others=%.0f, Height=%.1f Desc=%.1f\n" 4 	"\tAlign=%d, %d tabs. (%.0f before, %.0f after)\n", 	    p->indent1st, 	    p->indent2nd, 	    p->lineHt,  	    p->descentLine, 	    p->alignment, 	    p->numTabs, 	    style->spaceBefore, 	    style->spaceAfter); 	     ' 	for (tab=0; tab < p->numTabs; tab++) { ( 	    printf("\t\tTab kind=%d at %.0f\n", 		    p->tabs[tab].kind, 		    p->tabs[tab].x);     	} 	printf("\n");     } /* if paragraph */     return style;  }  #endif     /*			StyleSheet Functions  **			====================  */   /*	Searching for styles: */E HTStyle * HTStyleNamed ARGS2 (HTStyleSheet *,self, CONST char *,name)  {      HTStyle * scan; 2     for (scan=self->styles; scan; scan=scan->next)5         if (0==strcmp(scan->name, name)) return scan; J     if (TRACE) fprintf(stderr, "StyleSheet: No style named `%s'\n", name);
     return 0;  }   5 #ifdef NEXT_SUPRESS		/* Not in general common code */   ? HTStyle * HTStyleMatching (HTStyleSheet * self, HTStyle *style)  {      HTStyle * scan; 2     for (scan=self->styles; scan; scan=scan->next)1         if (scan->paragraph == para) return scan; 
     return 0;  }   - /*	Find the style which best fits a given run - **	------------------------------------------  **= **	This heuristic is used for guessing the style for a run of 3 **	text which has been pasted in. In order, we try:  **A **	A style whose paragraph structure is actually used by the run.  **	A style matching in font . **	A style matching in paragraph style exactly, **	A style matching in paragraph to a degree */  8 HTStyle * HTStyleForRun (HTStyleSheet *self, NXRun *run) {      HTStyle * scan;      HTStyle * best = 0;      int	bestMatch = 0;&     NXTextStyle * rp = run->paraStyle;2     for (scan=self->styles; scan; scan=scan->next)G         if (scan->paragraph == run->paraStyle) return scan;	/* Exact */   3     for (scan=self->styles; scan; scan=scan->next){ (     	NXTextStyle * sp = scan->paragraph;     	if (sp) { 	    int match = 0; 9 	    if (sp->indent1st ==	rp->indent1st)	match = match+1; 9 	    if (sp->indent2nd ==	rp->indent2nd)	match = match+2; 4 	    if (sp->lineHt ==		rp->lineHt)	match = match+1;6 	    if (sp->numTabs ==		rp->numTabs)	match = match+1;9 	    if (sp->alignment ==	rp->alignment)	match = match+3; 4 	    if (scan->font ==		run->font)	match = match+10; 	    if (match>bestMatch) {  		    best=scan; 		    bestMatch=match; 	    } 	}     } W     if (TRACE) fprintf(stderr, "HTStyleForRun: Best match for style is %d out of 18\n",      			 bestMatch);      return best; }  #endif     /*	Add a style to a sheet  **	----------------------  */) HTStyleSheet * HTStyleSheetAddStyle ARGS2 (   (HTStyleSheet *,self, HTStyle *,style) { 8     style->next = 0;		/* The style will go on the end */     if (!self->styles) {     	self->styles = style;     } else {     	HTStyle * scan;K         for(scan=self->styles; scan->next; scan=scan->next); /* Find end */  	scan->next=style;     }      return self; }     : /*	Remove the given object from a style sheet if it exists */, HTStyleSheet * HTStyleSheetRemoveStyle ARGS2(   (HTStyleSheet *,self, HTStyle *,style) {       if (self->styles == style) {      	self->styles = style->next;
 	return self;      } else {     	HTStyle * scan;4 	for(scan = self->styles; scan; scan = scan->next) { 	    if (scan->next == style) { " 	        scan->next = style->next; 		return self; 	    } 	}     } 
     return 0;  }    /*	Create new style sheet  */  % HTStyleSheet * HTStyleSheetNew NOARGS  { @     HTStyleSheet * self = (HTStyleSheet *)malloc(sizeof(*self));  5     memset((void*)self, 0, sizeof(*self));	/* ANSI */ & /* Harbison c ref man says (char*)self9    but k&r ansii and abc books and Think_C say (void*) */      / /*    bzero(self, sizeof(*self)); */		/* BSD */      return self; }     ! /*	Free off a style sheet pointer  */; HTStyleSheet * HTStyleSheetFree ARGS1 (HTStyleSheet *,self)  {      HTStyle * style;$     while((style=self->styles)!=0) {#         self->styles = style->next;  	HTStyleFree(style);     }      free(self); 
     return 0;  }     ( /*	Read a stylesheet from a typed stream( **	------------------------------------- **H **	Reads a style sheet from a stream.  If new styles have the same namesJ **	as existing styles, they replace the old ones without changing the ids. */  + #ifdef NEXT_SUPRESS  /* Only on the NeXT */ G HTStyleSheet * HTStyleSheetRead(HTStyleSheet * self, NXStream * stream)  {      int numStyles;
     int i;     HTStyle * style;     char styleName[80]; (     NXScanf(stream, " %d ", &numStyles);M     if (TRACE) fprintf(stderr, "Stylesheet: Reading %d styles\n", numStyles); !     for (i=0; i<numStyles; i++) { )         NXScanf(stream, "%s", styleName); .         style = HTStyleNamed(self, styleName); 	if (!style) {( 	    style = HTStyleNewNamed(styleName);. 	    (void) HTStyleSheetAddStyle(self, style); 	}# 	(void) HTStyleRead(style, stream);  	if (TRACE) HTStyleDump(style);      }      return self; }   ' /*	Write a stylesheet to a typed stream ' **	------------------------------------  **$ **	Writes a style sheet to a stream. */  H HTStyleSheet * HTStyleSheetWrite(HTStyleSheet * self, NXStream * stream) {      int numStyles = 0;     HTStyle * style;     B     for(style=self->styles; style; style=style->next) numStyles++;(     NXPrintf(stream, "%d\n", numStyles);     M     if (TRACE) fprintf(stderr, "StyleSheet: Writing %d styles\n", numStyles); 8     for (style=self->styles; style; style=style->next) {-         NXPrintf(stream, "%s ", style->name); $ 	(void) HTStyleWrite(style, stream);     }      return self; }  #endif