] /*                                                     HTML to rich text converter for libwww A                          THE HTML TO STYLED TEXT OBJECT CONVERTER -                                               8    This interprets the HTML semantics and some HTMLPlus.     )    Part of libwww . Implemented by HTML.c        */  #ifndef HTML_H #define HTML_H   #include "HTUtils.h" #include "HTFormat.h"  #include "HTAnchor.h"  #include "HTMLPDTD.h"    #define DTD HTMLP_dtd    #ifdef SHORT_NAMES( #define HTMLPresentation        HTMLPren( #define HTMLPresent             HTMLPres #endif  0 extern CONST HTStructuredClass HTMLPresentation;   /*  + HTML_new: A structured stream to parse HTML   Y    When this routine is called, the request structure may contain a childAnchor value.  I K    that case it is the responsability of this module to select  the anchor.                  */ : extern HTStructured* HTML_new PARAMS((HTRequest * request,7                                         void *   param, >                                         HTFormat input_format,?                                         HTFormat output_format, C                                         HTStream * output_stream));    /*     REOPEN   X    Reopening an existing HTML object allows it to be retained (for example by the styledX    text object) after the structured stream has been closed. To be actually deleted, theI    HTML object must  be closed once more times than it has been reopened.        */ 4 extern void HTML_reopen PARAMS((HTStructured * me));   /*  
 Converters    */ @ extern HTConverter HTMLToPlain, HTMLToC, HTMLPresent, HTMLToTeX;     /*  0 Selecting internal character set representations    */   typedef enum _HTMLCharacterSet {         HTML_ISO_LATIN1,         HTML_NEXT_CHARS,         HTML_PC_CP950  } HTMLCharacterSet;   = extern void HTMLUseCharacterSet PARAMS((HTMLCharacterSet i));    /*  * Record error message as a hypertext object  X    The error message should be marked as an error so that it can be reloaded later. ThisS    implementation just throws up an error message and leaves the document unloaded.         ON ENTRY,    A   sink                    is a stream to the output device if any                            2   number                  is the HTTP error number                           8   message                 is the human readable message.                           
   ON EXIT,   9    a return code like HT_LOADED if object exists else < 0        */  PUBLIC int HTLoadError PARAMS((          HTRequest *     req,         int             number, "         CONST char *    message));     /*   White Space Treatment   X    There is a small number of different ways of treating white space in SGML, in mappingD    from a text object to HTML. These have to be programmed it seems.       */    /*6 In text object  \n\n            \n      tab     \n\n\t7 --------------  -------------   -----   -----   -------  in Address,  Blockquote,  Normal,                             -               NORMAL H1-6:           close+open         -               HEADING  Glossary  8                                                 GLOSSARY List,  Menu                           -            LIST Dir   +                                         DIR ; Pre etc         \n\n            \n      \t              PRE    */  % typedef enum _white_space_treatment {          WS_NORMAL,         WS_HEADING,          WS_GLOSSARY,         WS_LIST,         WS_DIR,          WS_PRE } white_space_treatment;   /*  
 Nesting State   U    These elements form tree with an item for each nesting state: that is, each unique =    combination of nested elements which has a specific style.        */    typedef struct _HTNesting { K     void *                      style;  /* HTStyle *: Platform dependent */ $     white_space_treatment       wst;'     struct _HTNesting *         parent; /     int                         element_number; L     int                         item_number;    /* only for ordered lists */E     int                         list_level;     /* how deep nested */ )     HTList *                    children; 0     BOOL                        paragraph_break;&     int                         magic;N     BOOL                        object_gens_HTML; /* we don't generate HTML */ } HTNesting;     /*   Nesting functions   X    These functions were new with HTML2.c.  They allow the tree of SGML nesting states to@    be manipulated, and SGML regenerated from the style sequence.       */     ! extern void HTRegenInit NOPARAMS;   % extern void HTRegenCharacter PARAMS(( "         char                    c,(         HTNesting *             nesting,)         HTStructured *          target));   % extern  void HTNestingChange PARAMS((          HTStructured*   s,$         HTNesting*              old,$         HTNesting *             new,%         HTChildAnchor *         info, (         CONST char *            aName));  + extern HTNesting * HTMLCommonality PARAMS((          HTNesting *     s1,          HTNesting *     s2));   B extern HTNesting * HTNestElement PARAMS((HTNesting * p, int ele));H extern /* HTStyle * */ void * HTStyleForNesting PARAMS((HTNesting * n));  D extern HTNesting* HTMLAncestor PARAMS((HTNesting * old, int depth));S extern HTNesting* CopyBranch PARAMS((HTNesting * old, HTNesting * new, int depth)); 9 extern HTNesting * HTInsertLevel PARAMS((HTNesting * old, '                 int     element_number,                   int     level));9 extern HTNesting * HTDeleteLevel PARAMS((HTNesting * old,                   int     level));5 extern int HTMLElementNumber PARAMS((HTNesting * s)); . extern int HTMLLevel PARAMS(( HTNesting * s));D extern HTNesting* HTMLAncestor PARAMS((HTNesting * old, int depth));    #endif          /* end HTML_H */   /*  	    end */ 