] /*                                                           Rich Hypertext object for libWWW 7                                   RICH HYPERTEXT OBJECT -                                                 */    /*  T    This is the C interface to the Objective-C (or whatever) Style-oriented HyperTextZ    class. It is used when a style-oriented text object is available or craeted in order to    display hypertext.        */  #ifndef HTEXT_H  #define HTEXT_H  #include "HTAnchor.h"  #include "HTStyle.h" #include "HTStream.h"  #include "SGML.h"    #ifdef SHORT_NAMES0 #define HTMainText                      HTMaText0 #define HTMainAnchor                    HtMaAnch/ #define HText_new                       HTHTNew 0 #define HText_new2                      HTHTNew20 #define HText_free                      HTHTFree0 #define HText_beginAppend               HTHTBeAp0 #define HText_endAppend                 HTHTEnAp0 #define HText_setStyle                  HTHTSeSt0 #define HText_appendCharacter           HTHTApCh0 #define HText_appendImage               HTHTApIm0 #define HText_appendText                HTHTApTe0 #define HText_appendParagraph           HTHTApPa0 #define HText_beginAnchor               HTHTBeAn0 #define HText_endAnchor                 HTHTEnAn0 #define HText_dump                      HTHTDump0 #define HText_nodeAnchor                HTHTNoAn0 #define HText_select                    HTHTSele0 #define HText_selectAnchor              HTHTSeAn0 #define HText_applyStyle                HTHTApSt0 #define HText_updateStyle               HTHTUpSt0 #define HText_selectionStyle            HTHTStyl0 #define HText_replaceSel                HTHTRepl0 #define HText_applyToSimilar            HTHTApTo0 #define HText_selectUnstyled            HTHTSeUn0 #define HText_unlinkSelection           HTHTUnSe0 #define HText_linkSelTo                 HTHTLiSe0 #define HText_referenceSelected         HTHTRefS #endif   #ifndef THINK_C K #ifndef HyperText               /* Objective C version defined HyperText */ 4 typedef struct _HText HText;    /* Normal Library */ #else F @class HText;                   /* Objective C version for NeXTStep */ #endif #else > class CHyperText;               /* Mac Think-C browser hook */ typedef CHyperText HText;  #endif  J extern HText * HTMainText;              /* Pointer to current main text */N extern HTParentAnchor * HTMainAnchor;   /* Pointer to current text's anchor */   /*   Creation and deletion   $   HTEXT_NEW: CREATE HYPERTEXT OBJECT   Y    There are several methods depending on how much you want to specify. The output stream Y    is used with objects which need to output the hypertext to a stream.  The structure is X    for objects which need to refer to the structure which is kep by the creating stream.       */ A  extern HText * HText_new PARAMS((HTParentAnchor *      anchor));   ?  extern HText * HText_new2 PARAMS((HTParentAnchor *     anchor, H                                 HTStream *              output_stream));  @  extern HText * HText_new3 PARAMS((HTRequest *          request,F                                 HTStream *              output_stream,D                                 HTStructured *          structure));   /*     FREE HYPERTEXT OBJECT      */ 0 extern void     HText_free PARAMS((HText * me));     /*   Object Building methods   V    These are used by a parser to build the text in an object HText_beginAppend must beX    called, then any combination of other append calls, then HText_endAppend. This allowsL    optimised handling using buffers and caches which are flushed at the end.       */ 5 extern void HText_beginAppend PARAMS((HText * text));   3 extern void HText_endAppend PARAMS((HText * text));    /*     SET THE STYLE FOR FUTURE TEXT      */   C extern void HText_setStyle PARAMS((HText * text, HTStyle * style));    /*     ADD ONE CHARACTER      */ B extern void HText_appendCharacter PARAMS((HText * text, char ch));   /*     ADD A ZERO-TERMINATED STRING     */   F extern void HText_appendText PARAMS((HText * text, CONST char * str));   /*     NEW PARAGRAPH        and similar things        */ 9 extern void HText_appendParagraph PARAMS((HText * text));   9 extern void HText_appendLineBreak PARAMS((HText * text));   > extern void HText_appendHorizontalRule PARAMS((HText * text));       /*     START/END SENSITIVE TEXT     */    /*  U    The anchor object is created and passed to HText_beginAnchor. The senstive text is S    added to the text object, and then HText_endAnchor is called. Anchors may not be 
    nested.       */ J extern void HText_beginAnchor PARAMS((HText * text, HTChildAnchor * anc));3 extern void HText_endAnchor PARAMS((HText * text));      /*     SET THE NEXT FREE IDENTIFIER   T    The string must be of the form aaannnnn where aaa is the prefix for automaticallyT    generated ids, normally "z", and nnnn is the next unused number.  If not present,X    defaults to z0.  An editor should pick up both the a and n bits, and increment n whenW    generating ids. This ensures that old ids are not reused, even if the elements using ,    them have been deleted from the document.       */   $ extern void HText_setNextId PARAMS((         HText *         text,          CONST char *    s));   /*     APPEND AN INLINE IMAGE   S    The image is handled by the creation of an anchor whose destination is the image V    document to be included. The semantics is the intended inline display of the image.     V    An alternative implementation could be, for example, to begin an anchor, append theY    alternative text or "IMAGE", then end the anchor. This would simply generate some text 5    linked to the image itself as a separate document.        */ & extern void HText_appendImage PARAMS((         HText *         text,          HTChildAnchor * anc,)         CONST char *    alternative_text, "         CONST char *    alignment,          BOOL            isMap));   /*  ?   HTEXT_APPENDOBJECT:  APPEND AN OBJECT WHICH DOES ITS OWN WORK    R    The SGML parameters are passed untouched. Currently this is only used for emptyZ    elements.  Extensions could be (1) to pass CDATA contents as well as any attributes andW    (2) to pass the whole structured stream until the compound object has parsed itself.        */ ' extern void HText_appendObject PARAMS(( %         HText *                 text, /         int                     element_number, (         CONST BOOL *            present,(         CONST char * CONST *    value));   /*  C   HTEXT_UNIMPLEMENTED: WARN THAT OBJECT IS NOT COMPLETELY RENDERED.    Z    If the parser realises that it has incompletely parsed an object, then it can call thisT    to flag it to the object.  This will for example prevent editing or writing back.       */ ( extern void HText_unimplemented PARAMS((         HText *         text));      /*  	 Utilities      DUMP DIAGNOSTICS TO STDERR     */   , extern void HText_dump PARAMS((HText * me));   /*  -   RETURN THE ANCHOR ASSOCIATED WITH THIS NODE      */ > extern HTParentAnchor * HText_nodeAnchor PARAMS((HText * me));     /*   Browsing functions    */      /*  !   BRING TO FRONT AND HIGHLIGHT IT      */     0 extern BOOL HText_select PARAMS((HText * text));M extern BOOL HText_selectAnchor PARAMS((HText * text, HTChildAnchor* anchor));    /*   Editing functions   Y    These are called from the application. There are many more functions not included here U    from the orginal text object. These functions NEED NOT BE IMPLEMENTED in a browser     which cannot edit.        */  /*      Style handling:  */) /*      Apply this style to the selection  */B extern void HText_applyStyle PARAMS((HText * me, HTStyle *style));  + /*      Update all text with changed style.  */C extern void HText_updateStyle PARAMS((HText * me, HTStyle *style));   " /*      Return style of  selection */. extern HTStyle * HText_selectionStyle PARAMS((         HText * me,          HTStyleSheet* sheet));   /*      Paste in styled text */0 extern void HText_replaceSel PARAMS((HText * me,         CONST char *aString,         HTStyle* aStyle));  J /*      Apply this style to the selection and all similarly formatted text **      (style recovery only)  */E extern void HTextApplyToSimilar PARAMS((HText * me, HTStyle *style));   & /*      Select the first unstyled run. **      (style recovery only)  */J extern void HTextSelectUnstyled PARAMS((HText * me, HTStyleSheet *sheet));     /*      Anchor handling: */C extern void             HText_unlinkSelection PARAMS((HText * me)); E extern HTAnchor *       HText_referenceSelected PARAMS((HText * me)); O extern HTAnchor *       HText_linkSelTo PARAMS((HText * me, HTAnchor* anchor));      #endif /* HTEXT_H */ /*  	    end */ 