 /*			Error Output Module **			=================== **D **	This module contains the error / information generating function C **	HTErrorMsg() so taht it can be overwritten by smart browsers and  **	servers.  ** ** History: @ **  	05 May 94	Written by Henrik Frystyk, frystyk@dxcern.cern.ch */  * /* Implemention dependent include files */ #include "tcp.h"   /* Library include files */  #include "HTUtils.h" #include "HTAccess.h"  #include "HTAlert.h" #include "HTTCP.h" #include "HTChunk.h"0 #include "HTError.h"					 /* Implemented here */     /*								HTErrorMsg **D **	Default function that creates an error message using HTAlert() toE **	put out the contents of the error_stack messages. Furthermore, the H **	error_info structure contains a name of a help file that might be put8 **	up as a link. This file can then be multi-linguistic. **B **	This function might be overwritten by a smart server or client. */2 PUBLIC void HTErrorMsg ARGS1(HTRequest *, request) { '     HTList *cur = request->error_stack;      BOOL highest = YES;      HTChunk *chunk;      HTErrorInfo *pres;     if (!request) { < 	if (TRACE) fprintf(stderr, "HTErrorMsg.. Bad argument!\n"); 	return;     }   H     /* This check is only necessary if the error message is put down theI        stream, because we have to know if a stream has been put up and/or =        taken down again. Here it is only put as an example */      if (request->error_block) { a 	if (TRACE) fprintf(stderr, "HTErrorMsg.. No messages are printed as no stream is available.\n");  	return;     }        /* Output messages */      chunk = HTChunkCreate(128); =     while ((pres = (HTErrorInfo *) HTList_nextObject(cur))) {   0 	/* Check if we are going to show the message */@ 	if ((!pres->ignore || HTErrorShowMask & HT_ERR_SHOW_IGNORE) && * 	    (HTErrorShowMask & pres->severity)) {   	    /* Output code number */ 5 	    if (highest) {			    /* If first time through */  		if (TRACE) 		    fprintf(stderr, - 			    "HTError..... Generating message.\n");  		 		/* Output title */$ 		if (pres->severity == ERR_WARNING)% 		    HTChunkPuts(chunk, "Warning "); + 		else if (pres->severity == ERR_NON_FATAL) - 		    HTChunkPuts(chunk, "Non Fatal Error "); ' 		else if (pres->severity == ERR_FATAL) ) 		    HTChunkPuts(chunk, "Fatal Error "); & 		else if (pres->severity == ERR_INFO)) 		    HTChunkPuts(chunk, "Information ");  		else { 		    if (TRACE)] 			fprintf(stderr, "HTError..... Unknown Classification of Error (%d)...\n", pres->severity);  		    HTChunkFree(chunk); 
 		    return;  		}   8 		/* Only output error code if it is a real HTTP code */- 		if (pres->element < HTERR_HTTP_CODES_END) {  		    char codestr[10]; > 		    sprintf(codestr, "%d ", error_info[pres->element].code);" 		    HTChunkPuts(chunk, codestr); 		}  		highest = NO;  	    } else # 		HTChunkPuts(chunk, "\nReason: ");    	    /* Output error message */ ) 	    if (pres->element != HTERR_SYSTEM) { 4 		HTChunkPuts(chunk, error_info[pres->element].msg); 		HTChunkPutc(chunk, ' '); 	    }   	    /* Output parameters */; 	    if (pres->par && HTErrorShowMask & HT_ERR_SHOW_PARS) { 
 		int cnt;
 		char ch;, 		for (cnt=0; cnt<pres->par_length; cnt++) {& 		    ch = *((char *)(pres->par)+cnt);" 		    if (ch < 0x20 || ch >= 0x7F): 			HTChunkPutc(chunk, '#'); /* Can't print real content */
 		    else 			HTChunkPutc(chunk, ch); 		}  	    }   	    /* Output location */A 	    if (pres->where && HTErrorShowMask & HT_ERR_SHOW_LOCATION) { ) 		HTChunkPuts(chunk, "This occured in "); " 		HTChunkPuts(chunk, pres->where); 		HTChunkPutc(chunk, '\n');  	    }  3 	    /* We don't want the message more than once */ * 	    HTErrorIgnore(request, pres->handle); 	     8 	    /* If we only are going to show the higest entry */- 	    if (HTErrorShowMask & HT_ERR_SHOW_FIRST)  		break; 	}     }      HTChunkPutc(chunk,  '\n');     HTChunkTerminate(chunk);     if (chunk->size > 2) 	HTAlert(chunk->data);     HTChunkFree(chunk);      return;  }   