] /*                                            Utilities for the Authorization parts of libwww L              COMMON PARTS OF AUTHORIZATION MODULE TO BOTH SERVER AND BROWSER-                                               X    This module is the interface to the common parts of Access Authorization (AA) packageJ    for both server and browser. Important to know about memory allocation:     X    Routines in this module use dynamic allocation, but free automatically all the memory    reserved by them.     U    Therefore the caller never has to (and never should) free() any object returned by     these functions.      X    Therefore also all the strings returned by this package are only valid until the nextY    call to the same function is made. This approach is selected, because of the nature of X    access authorization: no string returned by the package needs to be valid longer than    until the next call.      Y    This also makes it easy to plug the AA package in: you don't have to ponder whether to Z    free() something here or is it done somewhere else (because it is always done somewhere	    else).      Z    The strings that the package needs to store are copied so the original strings given asL    parameters to AA functions may be freed or modified with no side effects.     R    Also note: The AA package does not free() anything else than what it has itself
    allocated.        */    #ifndef HTAAUTIL_H #define HTAAUTIL_H  8 #include "HTUtils.h"            /* BOOL, PARAMS, ARGS */ #include "HTList.h"  #include "tcp.h"   #ifdef SHORT_NAMES' #define HTAASenu        HTAAScheme_enum ' #define HTAASnam        HTAAScheme_name * #define HTAAteMa        HTAA_templateMatch3 #define HTAAmaPT        HTAA_makeProtectionTemplate ) #define HTAApALi        HTAA_parseArgList  #endif /*SHORT_NAMES*/     /*   Default filenames     */  #ifndef PASSWD_FILE 0 #define PASSWD_FILE     "/home2/luotonen/passwd" #endif   #ifndef GROUP_FILE/ #define GROUP_FILE      "/home2/luotonen/group"  #endif  " #define ACL_FILE_NAME   ".www_acl"     /* ** Numeric constants */L #define MAX_USERNAME_LEN        16      /* @@ Longest allowed username    */L #define MAX_PASSWORD_LEN        4*13    /* @@ Longest allowed password    */L                                         /* (encrypted, so really only 4*8)*/L #define MAX_METHODNAME_LEN      12      /* @@ Longest allowed method name */L #define MAX_FIELDNAME_LEN       16      /* @@ Longest field name in       */L                                         /* protection setup file          */L #define MAX_PATHNAME_LEN        80      /* @@ Longest passwd/group file   */L                                         /* patname to allow               */   /* ** Helpful macros  */) #define FREE(x) if (x) {free(x); x=NULL;}      /*' ** Access Authorization failure reasons  */ typedef enum {B     HTAA_OK,            /* 200 OK                               */B     HTAA_OK_GATEWAY,    /* 200 OK, acting as a gateway          */B     HTAA_OK_REDIRECT,   /* 302 OK, redirected                   */B     HTAA_NO_AUTH,       /* 401 Unauthorized, not authenticated  */B     HTAA_NOT_MEMBER,    /* 401 Unauthorized, not authorized     */B     HTAA_IP_MASK,       /* 403 Forbidden by IP mask             */B     HTAA_IP_MASK_PROXY, /* 403 Forbidden by IP mask on proxy    */B     HTAA_BY_RULE,       /* 403 Forbidden by rule                */B     HTAA_NO_ACL,        /* 403 Forbidden, ACL non-existent      */B     HTAA_NO_ENTRY,      /* 403 Forbidden, no ACL entry          */B     HTAA_SETUP_ERROR,   /* 403 Forbidden, server setup error    */B     HTAA_DOTDOT,        /* 403 Forbidden, URL with /../ illegal */B     HTAA_HTBIN,         /* 403 Forbidden, /htbin not enabled    */     HTAA_INVALID_REDIRECT,B                         /* 403 Forbidden, bad redirection setup */B     HTAA_INVALID_USER,  /* 403 Forbidden, bad user directory    */B     HTAA_NOT_ALLOWED,   /* 403 Forbidden, dangerous method must */B                         /*                be explicitly allowed */B     HTAA_NOT_FOUND,     /* 404 Not found, or read protected     */B     HTAA_MULTI_FAILED   /* 404 No suitable presentation found   */ } HTAAFailReason;      /*   Datatype definitions     HTAASCHEME   X    The enumeration HTAAScheme represents the possible authentication schemes used by the    WWW Access Authorization.       */    typedef enum {     HTAA_UNKNOWN,      HTAA_NONE,     HTAA_BASIC,      HTAA_PUBKEY,     HTAA_KERBEROS_V4,      HTAA_KERBEROS_V5, F     HTAA_MAX_SCHEMES /* THIS MUST ALWAYS BE LAST! Number of schemes */
 } HTAAScheme;    /*   Authentication Schemes    */   I /* PUBLIC                                               HTAAScheme_enum() = **              TRANSLATE SCHEME NAME TO A SCHEME ENUMERATION  ** ON ENTRY:A **      name            is a string representing the scheme name.  ** ** ON EXIT: @ **      returns         the enumerated constant for that scheme. */= PUBLIC HTAAScheme HTAAScheme_enum PARAMS((CONST char* name));     I /* PUBLIC                                               HTAAScheme_name() 6 **                      GET THE NAME OF A GIVEN SCHEME ** ON ENTRY:9 **      scheme          is one of the scheme enum values: ? **                      HTAA_NONE, HTAA_BASIC, HTAA_PUBKEY, ...  ** ** ON EXIT: 4 **      returns         the name of the scheme, i.e.6 **                      "none", "basic", "pubkey", ... */9 PUBLIC char *HTAAScheme_name PARAMS((HTAAScheme scheme));     L /* PUBLIC                                           HTAA_templateCaseMatch()9 **              STRING COMPARISON FUNCTION FOR FILE NAMES I **                 WITH ONE WILDCARD * IN THE TEMPLATE (Case Insensitive)  ** NOTE:G **      This is essentially the same code as in HTAA_templateMatch, but G **      it compares case insensitive (for VMS). Reason for this routine H **      is that HTAA_templateMatch gets called from several places, alsoH **      there where a case sensitive match is needed, so one cannot just6 **      change the HTAA_templateMatch routine for VMS. ** ** ON ENTRY:C **      template        is a template string to match the file name = **                      agaist, may contain a single wildcard > **                      character * which matches zero or more- **                      arbitrary characters. C **      filename        is the filename (or pathname) to be matched , **                      agaist the template. ** ** ON EXIT: > **      returns         YES, if filename matches the template.& **                      NO, otherwise. */A PUBLIC BOOL HTAA_templateCaseMatch PARAMS((CONST char * template, C                                            CONST char * filename));     M /* PUBLIC                                       HTAA_makeProtectionTemplate() : **              CREATE A PROTECTION TEMPLATE FOR THE FILES7 **              IN THE SAME DIRECTORY AS THE GIVEN FILE > **              (Used by server if there is no fancier way for? **              it to tell the client, and by browser if server : **              didn't send WWW-ProtectionTemplate: field) ** ON ENTRY:4 **      docname is the document pathname (from URL). ** ** ON EXIT: < **      returns a template matching docname, and other files( **              files in that directory. **6 **              E.g.  /foo/bar/x.html  =>  /foo/bar/ *5 **                                                  ^ = **                              Space only to prevent it from < **                              being a comment marker here,= **                              there really isn't any space.  */H PUBLIC char *HTAA_makeProtectionTemplate PARAMS((CONST char * docname)); /*   MIME Argument List Parser     */     K /* PUBLIC                                               HTAA_parseArgList() > **              PARSE AN ARGUMENT LIST GIVEN IN A HEADER FIELD ** ON ENTRY:* **      str     is a comma-separated list: **( **                      item, item, item **              where & **                      item ::= value+ **                             | name=value - **                             | name="value"  **: **              Leading and trailing whitespace is ignoredA **              everywhere except inside quotes, so the following # **              examples are equal:  *** **                      name=value,foo=bar/ **                       name="value",foo="bar" 3 **                        name = value ,  foo = bar 8 **                         name = "value" ,  foo = "bar" ** ** ON EXIT: C **      returns a list of name-value pairs (actually HTAssocList*). ? **              For items with no name, just value, the name is = **              the number of order number of that item. E.g. ' **              "1" for the first, etc.  */6 PUBLIC HTList *HTAA_parseArgList PARAMS((char * str));   /*    */    #endif  /* NOT HTAAUTIL_H */ /*      End of file HTAAUtil.h. */ 