D /*                          BROWSER SIDE ACCESS AUTHORIZATION MODULE-                                               V    This module is the browser side interface to Access Authorization (AA) package.  It"    contains code only for browser.     -    Important to know about memory allocation:      X    Routines in this module use dynamic allocation, but free automatically all the memory    reserved by them.     U    Therefore the caller never has to (and never should) free() any object returned by     these functions.      X    Therefore also all the strings returned by this package are only valid until the nextY    call to the same function is made. This approach is selected, because of the nature of X    access authorization: no string returned by the package needs to be valid longer than    until the next call.      Y    This also makes it easy to plug the AA package in: you don't have to ponder whether to Y    free()something here or is it done somewhere else (because it is always done somewhere 	    else).      Z    The strings that the package needs to store are copied so the original strings given asL    parameters to AA functions may be freed or modified with no side effects.     Q    Also note:The AA package does not free() anything else than what it has itself 
    allocated.        */    #ifndef HTAABROW_H #define HTAABROW_H  8 #include "HTUtils.h"            /* BOOL, PARAMS, ARGS */8 #include "HTAAUtil.h"           /* Common parts of AA */ #include "HTList.h"  #include "HTAssoc.h"   #ifdef SHORT_NAMES( #define HTAAcoAu        HTAA_composeAuth0 #define HTAAsRWA        HTAA_shouldRetryWithAuth #endif /*SHORT_NAMES*/     /* ** Local datatype definitions  **< ** HTAAServer contains all the information about one server. */ typedef struct {  B     char *      hostname;       /* Host's name                  */B     int         portnumber;     /* Port number                  */B     HTList *    setups;         /* List of protection setups    */B                                 /* on this server; i.e. valid   */B                                 /* authentication schemes and   */B                                 /* templates when to use them.  */B                                 /* This is actually a list of   */B                                 /* HTAASetup objects.           */B     HTList *    realms;         /* Information about passwords  */
 } HTAAServer;      /*8 ** HTAASetup contains information about one server's one ** protected tree of documents.  */ typedef struct {O     HTAAServer *server;         /* Which server serves this tree             */ O     char *      template;       /* Template for this tree                    */ O     HTList *    valid_schemes;  /* Valid authentic.schemes                   */ O     HTAssocList**scheme_specifics;/* Scheme specific params                  */ O     BOOL        reprompt;       /* Failed last time -- reprompt (or whatever)*/  } HTAASetup;     /*/ ** Information about usernames and passwords in + ** Basic and Pubkey authentication schemes;  */ typedef struct {B     char *      realmname;      /* Password domain name         */B     char *      username;       /* Username in that domain      */B     char *      password;       /* Corresponding password       */ } HTAARealm;    / #include "HTAccess.h"           /* HTRequest */    /*  . Routines for Browser Side Recording of AA Info  W    Most of the browser-side AA is done by the following two functions (which are called T    from file HTTP.c so the browsers using libwww only need to be linked with the new&    library and not be changed at all):     U       HTAA_composeAuth() composes the Authorization: line contents, if the AA package X       thinks that the given document is protected. Otherwise this function returns NULL.Z       This function also calls the functions HTPrompt(),HTPromptPassword() and HTConfirm()H       to get the username, password and some confirmation from the user.       Z       HTAA_shouldRetryWithAuth() determines whether to retry the request with AA or with a;       new AA (in case username or password was misspelled).          */   J /* BROWSER PUBLIC                                       HTAA_composeAuth() **3 **      COMPOSE Authorization: HEADER LINE CONTENTS @ **      IF WE ALREADY KNOW THAT THE HOST REQUIRES AUTHENTICATION ** ** ON ENTRY:/ **      req             request, which contains > **      req->argument   document, that we're trying to access.9 **      req->setup      protection setup info on browser. 7 **      req->scheme     selected authentication scheme. C **      req->realm      for Basic scheme the username and password.  ** ** ON EXIT: ? **      returns NO, if no authorization seems to be needed, and + **              req->authorization is NULL. < **              YES, if it has composed Authorization field,B **              in which case the result is in req->authorization, **              e.g. **4 **                 "Basic AkRDIhEF8sdEgs72F73bfaS==" */7 PUBLIC BOOL HTAA_composeAuth PARAMS((HTRequest * req));     L /* BROWSER PUBLIC                                       HTAA_retryWithAuth() **: **              RETRY THE SERVER WITH AUTHORIZATION (OR IF: **              ALREADY RETRIED, WITH A DIFFERENT USERNAME: **              AND/OR PASSWORD (IF MISSPELLED)) OR CANCEL ** ON ENTRY:  **      req             request. **      req->valid_schemes@ **                      This function should only be called whenD **                      server has replied with a 401 (Unauthorized)F **                      status code, and req structure has been filledD **                      up according to server reply, especially theD **                      req->valid_shemes list must have been set up? **                      according to WWW-Authenticate: headers. > **      callback        the function to call when username andB **                      password have been entered (HTLoadHTTP()). ** ON EXIT: = **      On GUI clients pops up a username/password dialog box  **      with "Ok" and "Cancel". . **      "Ok" button press should do a callback **  **              HTLoadHTTP(req); **: **      This actually done by function HTPasswordDialog(),# **      which GUI clients redefine.  **9 **      returns         YES, if dialog box was popped up. ' **                      NO, on failure.  */D PUBLIC BOOL HTAA_retryWithAuth PARAMS((HTRequest *              req,K                                        HTRetryCallbackType      callback));     F /* PUPLIC                                               HTAA_cleanup() **K **      Free the memory used by the entries concerning Access Authorization = **      in the request structure and put all pointers to NULL  **      Henrik 14/03-94. ** ** ON ENTRY:- **      req             the request structure  ** ** ON EXIT:   **      returns         nothing. */1 PUBLIC void HTAACleanup PARAMS((HTRequest *req));  /*  0 Enabling Gateway httpds to Forward Authorization  V    These functions should only be called from daemon code, and HTAAForwardAuth_reset()T    must be called before the next request is handled to make sure that authorizationT    string isn't cached in daemon so that other people can access private files using5    somebody elses previous authorization information.        */   A PUBLIC void HTAAForwardAuth_set PARAMS((CONST char * scheme_name, H                                         CONST char * scheme_specifics));+ PUBLIC void HTAAForwardAuth_reset NOPARAMS;  /*    */    #endif  /* NOT HTAABROW_H */ /*      End of file HTAABrow.h.  */