   /*								HTWild.h  *	WILDCARD MATCHING MODULE   *	* * * * * * * * * * * * *  *
  * Author:<  *	Ari Luotonen, CERN, April 1994, <luotonen@dxcern.cern.ch>  *3  * This interface contains the following functions:   *  *	HTPattern_new(str) 8  *		returns an internal representation (HTPattern *) for<  *		a given a string.  This can be used when later comparing%  *		actual strings against templates. #  *		Asterisk * means any character. 7  *		Any character can be escaped by preceding it with a 9  *		backslash; at least * and \ must be escaped when they 8  *		should be taken literally, but all other escapes are  *		also understood.  *  *	HTPattern_free(pat)1  *		frees the memory taken up by the pattern pat.   *  *	HTPattern_match(pat,eqv,act) 6  *		matches the actual string act against pattern pat.6  *		If the pattern eqv is non-NULL the result returned6  *		will be a new string where the string is mapped to6  *		pattern eqv.  If eqv is NULL, a copy of the actual  *		string is returned. 6  *		If act doesn't match the pattern NULL is returned.9  *		NOTE: /~ in the beginning must be explicitly matched.   *  *	HTPattern_firstWild(pat,act) 7  *		takes a pattern and a string matching that pattern, 8  *		and returns a pointer inside the string to the first7  *		character matched by the first wildcard in pattern. 6  *		IMPORTANT: string really has to match the pattern,2  *		i.e. it must have HTPattern_match()'ed before.  *  *	HTPattern_url_match(pat,url) 6  *		takes a pattern and a URL-escaped URL, and matches4  *		an unescaped version of URL against the pattern;)  *		returns YES on match, NO on mismatch.   *D  *	The datatype HTPattern should be treated as an abstract datatype.  */    #ifndef HTWILD_H #define HTWILD_H   #include "HTUtils.h"   typedef struct _HTPattern { 2     BOOL		wild;	/* If wildcard before this text */4     char *		text;	/* Required text after wildcard */>     struct _HTPattern *	next;	/* Next required text portion */ } HTPattern;  < PUBLIC HTPattern * HTPattern_new PARAMS((CONST char * str));8 PUBLIC void	   HTPattern_free PARAMS((HTPattern * pat));9 PUBLIC char *	   HTPattern_match PARAMS((HTPattern *	pat,  					   HTPattern *	eqv, 					   CONST char *	act)); = PUBLIC char *	   HTPattern_firstWild PARAMS((HTPattern * pat,  					       char *	   act));8 PUBLIC BOOL HTPattern_url_match PARAMS((HTPattern *	pat, 					CONST char *	url));   #endif /* HTWILD_H */   