C /*                          SERVER SIDE ACCESS AUTHORIZATION MODULE -                                               T    This module is the server side interface to Access Authorization (AA) package. It!    contains code only for server.      -    Important to know about memory allocation:      X    Routines in this module use dynamic allocation, but free automatically all the memory    reserved by them.     U    Therefore the caller never has to (and never should) free() any object returned by     these functions.      X    Therefore also all the strings returned by this package are only valid until the nextY    call to the same function is made. This approach is selected, because of the nature of X    access authorization: no string returned by the package needs to be valid longer than    until the next call.      Y    This also makes it easy to plug the AA package in: you don't have to ponder whether to Y    free()something here or is it done somewhere else (because it is always done somewhere 	    else).      Z    The strings that the package needs to store are copied so the original strings given asL    parameters to AA functions may be freed or modified with no side effects.     Q    Also note:The AA package does not free() anything else than what it has itself 
    allocated.        */    #ifndef HTAASERV_H #define HTAASERV_H  : #include <stdio.h>              /* FILE                 */: #include "HTUtils.h"            /* BOOL, PARAMS, ARGS   */L #include "HTRules.h"            /* This module interacts with rule system */: #include "HTAAUtil.h"           /* Common parts of AA   */: #include "HTAuth.h"             /* Authentication       */     #ifdef SHORT_NAMES* #define HTAAstMs        HTAA_statusMessage/ #define HTAAchAu        HTAA_checkAuthorization / #define HTAAcoAH        HTAA_composeAuthHeaders ) #define HTAAsLog        HTAA_startLogging  #endif /*SHORT_NAMES*/   /*   Check Access Authorization  G    HTAA_checkAuthorization() is the main access authorization function.        */   O /* PUBLIC                                             HTAA_checkAuthorization() < **              CHECK IF USER IS AUTHORIZED TO ACCESS A FILE ** ON ENTRY:8 **      req     data structure representing the request. ** ** ON EXIT: 8 **      returns status codes uniform with those of HTTP:0 **        200 OK           if file access is ok.7 **        401 Unauthorized if user is not authorized to + **                         access the file. 7 **        403 Forbidden    if there is no entry for the 5 **                         requested file in the ACL.  ** ** NOTE:5 **      This function does not check whether the file 5 **      exists or not -- so the status  404 Not found 5 **      must be returned from somewhere else (this is 4 **      to avoid unnecessary overhead of opening the **      file twice). ** */= PUBLIC int HTAA_checkAuthorization PARAMS((HTRequest * req));  /*   Compose Status Line Message     */   L /* SERVER PUBLIC                                        HTAA_statusMessage()1 **              RETURN A STRING EXPLAINING ACCESS % **              AUTHORIZATION FAILURE 8 **              (Can be used in server reply status line' **               with 401/403 replies.)  ** ON ENTRY:  **      req     failing request. ** ON EXIT: 5 **      returns a string containing the error message 9 **              corresponding to internal HTAAFailReason.  */: PUBLIC char *HTAA_statusMessage PARAMS((HTRequest * req)); /*  5 Compose "Authenticate:" Header Lines for Server Reply     */   M /* SERVER PUBLIC                                    HTAA_composeAuthHeaders() 6 **              COMPOSE WWW-Authenticate: HEADER LINES7 **              INDICATING VALID AUTHENTICATION SCHEMES * **              FOR THE REQUESTED DOCUMENT ** ON ENTRY: **      req     request. ** ** ON EXIT: = **      returns a buffer containing all the WWW-Authenticate: C **              fields including CRLFs (this buffer is auto-freed). ? **              NULL, if authentication won't help in accessing ' **              the requested document.  */? PUBLIC char *HTAA_composeAuthHeaders PARAMS((HTRequest * req));  /*  " Start Access Authorization Logging    */   K /* PUBLIC                                               HTAA_startLogging() 5 **              START UP ACCESS AUTHORIZATION LOGGING  ** ON ENTRY:% **      fp      is the open log file.  ** */2 PUBLIC void HTAA_startLogging PARAMS((FILE * fp));  6 PUBLIC void HTSetAttributes PARAMS((HTRequest *   req,>                                     struct stat * stat_info));  4 PUBLIC BOOL HTGetAttributes PARAMS((HTRequest * req,7                                     char *      path));    /*    */    #endif  /* NOT HTAASERV_H */ /*      End of file HTAAServ.h.  */