: /*                                   PROTECTION SETUP FILE-                                                 */    #ifndef HTAAPROT_H #define HTAAPROT_H   #include "HTUtils.h" #include "HTGroup.h" #include "HTAssoc.h"     #ifdef SHORT_NAMES# #define HTAAgUid        HTAA_getUid # #define HTAAgGid        HTAA_getGid 1 #define HTAAgDPr        HTAA_setDefaultProtection 1 #define HTAAsCPr        HTAA_setCurrentProtection 1 #define HTAAgCPr        HTAA_getCurrentProtection 1 #define HTAAgDPr        HTAA_getDefaultProtection - #define HTAAclPr        HTAA_clearProtections  #endif /*SHORT_NAMES*/   typedef struct _HTUidGid {     char *      uname;     char *      gname;     int         uid;     int         gid; } HTUidGid;    /*6  *      Allocate and free a new uid and gid structure;?  *      set the current ids to eventually run as (done by calls   *      from the rule module).  */ < PUBLIC HTUidGid * HTUidGid_new PARAMS((char * u, char * g));2 PUBLIC void HTUidGid_free PARAMS((HTUidGid * ug));5 PUBLIC void HTSetCurrentIds PARAMS((HTUidGid * ids));  /*  6 Server's Representation of Document (Tree) Protections    */    typedef struct {J     char *        template;     /* Template for this protection         */ #ifdef NOT_NEEDED_NOR_SHOULD_BE J     char *        filename;     /* Current document file                */ #endifJ     HTUidGid *    ids;          /* User and group ids to run as         */J     BOOL          acl_override; /* Do ACL's override Masks              */J     GroupDef *    get_mask;     /* Allowed users and IP addresses (GET) */J     GroupDef *    put_mask;     /*  - " - (PUT)                         */J     GroupDef *    post_mask;    /*  - " - (POST)                        */J     GroupDef *    delete_mask;  /*  - " - (DELETE)                      */J     GroupDef *    gen_mask;     /* General mask (used when needed but   */J                                 /* other masks not set).                */J     HTList *      valid_schemes;/* Valid authentication schemes         */J     HTAssocList * values;       /* Association list for scheme specific */J                                 /* parameters.                          */ } HTAAProt;   > extern HTAAProt * HTProt;       /* Current protection setup */> extern HTAAProt * HTDefProt;    /* Default protection setup */     /*    */     1 #include "HTAccess.h"   /* HTRequest structure */    /*   Callbacks for rule system   @    The following three functioncs are called by the rule system:     C       HTAA_clearProtections() when starting to translate a filename        @       HTAA_setDefaultProtection() when "defprot" rule is matched       @       HTAA_setCurrentProtection() when "protect" rule is matched       8    Protection setup files are cached by these functions.       */   K /* PUBLIC                                       HTAA_setDefaultProtection() / **              SET THE DEFAULT PROTECTION MODE - **              (called by rule system when a * **              "defprot" rule is matched) ** ON ENTRY:  **      req             request.E **      prot_filename   is the protection setup file (second argument 5 **                      for "defprot" rule, optional) ? **      eff_ids         contains user and group id information.  ** ** ON EXIT:   **      returns         nothing.C **                      Sets the module-wide variable default_prot.  */D PUBLIC void HTAA_setDefaultProtection PARAMS((HTRequest *       req,N                                               CONST char *      prot_filename,J                                               HTUidGid *        eff_ids));      K /* PUBLIC                                       HTAA_setCurrentProtection() / **              SET THE CURRENT PROTECTION MODE - **              (called by rule system when a * **              "protect" rule is matched) ** ON ENTRY:  **      req             request.E **      prot_filename   is the protection setup file (second argument 5 **                      for "protect" rule, optional) ? **      eff_ids         contains user and group id information.  ** ** ON EXIT:   **      returns         nothing.C **                      Sets the module-wide variable current_prot.  */D PUBLIC void HTAA_setCurrentProtection PARAMS((HTRequest *       req,N                                               CONST char *      prot_filename,J                                               HTUidGid *        eff_ids));    O /* SERVER INTERNAL                                      HTAA_clearProtections() . **              CLEAR DOCUMENT PROTECTION MODE) **              (ALSO DEFAULT PROTECTION) + **              (called by the rule system)  ** ON ENTRY: **      No arguments.  ** ** ON EXIT:  **      returns nothing.@ **              Frees the memory used by protection information. */+ PUBLIC void HTAA_clearProtections NOPARAMS;  /*   Getting Protection Settings   U       HTAA_getCurrentProtection() returns the current protection mode (if there was a C       "protect" rule). NULL, if no "protect" rule has been matched.        X       HTAA_getDefaultProtection() sets the current protection mode to what it was set toK       by "defprot" rule and also returns it (therefore after this call also =       HTAA_getCurrentProtection() returns the same structure.          */   K /* PUBLIC                                       HTAA_getCurrentProtection() 6 **              GET CURRENT PROTECTION SETUP STRUCTURE6 **              (this is set up by callbacks made from8 **               the rule system when matching "protect"' **               (and "defprot") rules)  ** ON ENTRY:: **      HTTranslate() must have been called before calling **      this function. ** ** ON EXIT: 5 **      returns a HTAAProt structure representing the = **              protection setup of the HTTranslate()'d file. * **              This must not be free()'d. */4 PUBLIC HTAAProt *HTAA_getCurrentProtection NOPARAMS;      K /* PUBLIC                                       HTAA_getDefaultProtection() 6 **              GET DEFAULT PROTECTION SETUP STRUCTURE6 **              (this is set up by callbacks made from8 **               the rule system when matching "defprot" **               rules)  ** ON ENTRY:: **      HTTranslate() must have been called before calling **      this function. ** ** ON EXIT: 5 **      returns a HTAAProt structure representing the ? **              default protection setup of the HTTranslate()'d = **              file (if HTAA_getCurrentProtection() returned 8 **              NULL, i.e. if there is no "protect" rule; **              but ACL exists, and we need to know default % **              protection settings). * **              This must not be free()'d. */4 PUBLIC HTAAProt *HTAA_getDefaultProtection NOPARAMS; /*  & Get User and Group IDs to Which Set to    */    #ifndef VMS M /* PUBLIC                                                       HTAA_getUid() < **              GET THE USER ID TO CHANGE THE PROCESS UID TO ** ON ENTRY: **      req     request. ** ** ON EXIT: ? **      returns the uid number to give to setuid() system call. * **              Default is 65534 (nobody). */  PUBLIC int HTAA_getUid NOPARAMS;    M /* PUBLIC                                                       HTAA_getGid() = **              GET THE GROUP ID TO CHANGE THE PROCESS GID TO  ** ON ENTRY: **      req     request. ** ** ON EXIT: ? **      returns the uid number to give to setgid() system call. + **              Default is 65534 (nogroup).  */  PUBLIC int HTAA_getGid NOPARAMS; #endif /* not VMS */ /*      For VMS:        */   
 #ifdef VMSQ /* PUBLIC                                                       HTAA_getUidName() / **              GET THE USER ID NAME (VMS ONLY)  ** ON ENTRY: **      No arguments.  ** ** ON EXIT:  **      returns the user name ' **              Default is "" (nobody).  */' PUBLIC char * HTAA_getUidName NOPARAMS;   P /* PUBLIC                                                       HTAA_getFileName+ **              GET THE FILENAME (VMS ONLY)  ** ON ENTRY: **      No arguments.  ** ** ON EXIT:  **      returns the filename */( PUBLIC char * HTAA_getFileName NOPARAMS; #endif /* VMS */ /*    */     < PUBLIC HTAAProt * HTAAProt_parseInlined PARAMS((FILE * fp));   #endif /* not HTAAPROT_H */  /*      End of file HTAAProt.h.  */