/* serve UNIX tape, for ZT4/ZTserver (via TCP/IP) */
/*
 * w.j.m. oct 1992, after (IBM VM/CMS/INTERLINK) ZTNS3
 * mod 08-aug-1994 wjm: allow for writelock status via extern TAPE_hwl
 * mod 10-aug-1994 wjm: rewind tape after re-load & check for HWL again
 * mod 11-sep-1995 wjm: support known IO$_DISPLAY functions via standard output
 *
 * #ifdef FAKE_FSR, add code to simulate TAPFSR by TAPRD
 * (TAPBSR isn't that easy ...)
 *
 * #ifdef CTAPE, use ct_XXX routines instead of TAPxxx()
 */

#include "ztns4vms.h"   /* SS$_,IO$_,MT$_ stuff */
#include "ztns4.h"      /* must be same as on VMS */
 
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
 

#ifdef TRACE
#define TRACE1(n,s) f_trace(n,s)
#else
#define TRACE1(n,s) (s)
#endif

#ifdef CTAPE
#define TAPREW ct_rew
#define TAPRUN ct_run
#define TAPFSR ct_fsr
#define TAPBSR ct_bsr
#define TAPRD ct_read
#define TAPWTM ct_wtm
#define TAPWR ct_write
#endif
extern int
  TAPREW(void),
  TAPRUN(void),
  TAPFSR(void),
  TAPBSR(void),
  TAPRD(void *,int,int *),
  TAPWTM(void),
  TAPWR(void *,int);
 
#if 1
int TAPE_hwl;
#define TAPE_HWL (TAPE_hwl)
#else
#define TAPE_HWL (0)
#endif

static void FEHLER();
 
#define MIN(a,b) ((a) < (b)) ? (a) : (b)
 

typedef struct {
	unsigned char ub[8];
} ZT_MEDIA;				/* used with DISPLAY (not SWAPped) */
 
/***** tape data *****/
static unsigned char t_buffer[0xFFFF];
static IOSB t_iosb;			/* note that .devdep is saved here */
#define MT_clr(m) t_iosb.devdep &= ~(m)
#define MT_set(m) t_iosb.devdep |= m
static int t_record = 0;                /* current tape position,
                                        /* required in order to find out
                                        /* if skip backward reaches BOT */
 
static int t_eotrec = -1;               /* position after 1st EOT indication,
                                        /* or -1 if unknown */
 
static int/*logical*/ t_unloaded = 0;   /* flag unload,
                                        /* manual intervention required
                                        /*  (I guess)! */
 
static unsigned short ti_iofunc;        /* request function, !=0 while busy */
static int ti_count;                    /* request count */
static ZT_MEDIA ti_media;               /* request parameter(s) */
 
static unsigned char *ti_datap = NULL;  /* input 'DMA' pointer,
                                                ==NULL unless data expected */
static int ti_datacnt = 0;              /* input 'DMA' counter */
 
static unsigned short ti_replysts;      /* status from IOREPLY */
 
 
/***** network data *****/
        /* ZT -> NS */
static ZTNS_MSG ni_buf;
static ZT_MEDIA ni_buf_media;		/* little-endian copy of ni_buf.iosb */
static int ni_seq = 1;
 
        /* NS -> ZT (our output) */
/* static ZTNS_MSG no_buf; */
static struct Tcp_no_buf {
  unsigned char fill[6];	/* suppress padding between l[] and nobuf */
  unsigned char l[2];
  ZTNS_MSG nobuf;
} tcp_no_buf;
#define no_buf (tcp_no_buf.nobuf)
static int no_seq = 1;
 
 
/* misc data */
static char eline[133];
 
 
/*****/
 
static void ztns_swap();        /* forward */
static void tcp_send();
static int tcp_rcv();            /* forward */
 
 
static void net_send(fct)
int fct;        /* ZTNS_F_xxxx */
{
        int c;
 
 
        no_buf.seq = no_seq++;
        no_buf.func = fct;
 
        c = (fct == ZTNS_F_DATA) ?
                (ZTNS_LEN1 + no_buf.count) : ZTNS_LEN1;
 
        ztns_swap(&no_buf);
        tcp_send(&no_buf,c);
}
 
 
static void net_rcv(fct)        /* receive net msg */
int fct;        /* desired ZTNS_F_xxxx */
{
        int rcvlen;
        int/*logical*/ more;
 
 
        do {
                more = 0;       /* assume only 1 msg */
 
                rcvlen = tcp_rcv(&ni_buf,sizeof(ni_buf));

		/* make un-swapped copy of ni_buf.iosb */
		assert(sizeof(ni_buf.iosb) == 8);
		assert(sizeof(ni_buf_media) == 8);
		memcpy(&ni_buf_media,&ni_buf.iosb,8);

                ztns_swap(&ni_buf);
 
/* check seq# */
                if(ni_buf.seq != ni_seq++) FEHLER("prot.error: iseq");
 
/* check minimum length */
                if(rcvlen < ZTNS_LEN1) FEHLER("prot.error: msg too short");
 
/* process low level function */
                if(ni_buf.func != fct) {
                        sprintf(eline,
                           "prot.error: unexpected message %d, expected %d",
                                ni_buf.func,fct);
                        FEHLER(eline);
                }
 
                switch(fct) {
                  default:
                        FEHLER("net_rcv: bad fct");
                        break;
 
                  case ZTNS_F_IOREPLY:
                        ti_replysts = ni_buf.iosb.status;
                        break;
 
                  case ZTNS_F_IOREQ:
                        ti_iofunc = ni_buf.iofunc;
                        ti_count = ni_buf.count;
			ti_media = ni_buf_media;	/* for DISPLAY */
                        break;
 
                  case ZTNS_F_DATA:
                        if(ti_datap == NULL) {
                                FEHLER("net_rcv: ti_datap == NULL");
                        }
                        if(rcvlen != ZTNS_LEN1 + ni_buf.count) {
                                FEHLER("prot.error: bad DATA msg length");
                        }
                        if(ni_buf.count > ti_datacnt) {
                                FEHLER("prot.error: too much data");
                        }
 
                        memcpy(ti_datap,ni_buf.data,ni_buf.count);
                        ti_datacnt -= ni_buf.count;
                        ti_datap += ni_buf.count;
 
                        if(ti_datacnt > 0) more = 1; /* more data ... */
                        break;
                }
        } while(more);
}
 
 
/*****/

#ifdef TRACE
static int f_trace(char *n, int s)
{
  fprintf(stdout,"   %s (record=%d) => %d\n",n,t_record,s);
  return s;
}
#endif

/*****/
 
static unsigned short tap2sts(retcode)
int retcode;
{
        switch(retcode) {
          case 0:
                return SSs_NORMAL;
          case 2:
                return SSs_ENDOFFILE;
          case 3:
                MT_set(MTsM_LOST);
                return SSs_DRVERR;
          case 6:
                MT_set(MTsM_HWL);
                return SSs_WRITLCK;
          case 8:
                return SSs_DATAOVERUN;
        }
 
        sprintf(eline,"bad tape status %d",retcode);
        FEHLER(eline);
}
 
 
static void tap_invfun()        /* unsupported function or modifier */
{
        t_iosb.status = SSs_ILLIOFUNC;
        t_iosb.count = 0;
        /* t_iosb.devdep not changed */
}
 
 
static void tap_display()       /* somewhat reduced functionality,
                                 * have to guess at actual parameters */
{
        unsigned int itemcode,mode;

        itemcode = ti_media.ub[0];
        mode = ti_media.ub[1];

	/* assume success */
	t_iosb.status = SSs_NORMAL;
	t_iosb.count = 0;

        if(itemcode == 0) {
		/* no-op */
	} else if(itemcode == 1 && mode == 0) {
                printf("DISPLAY ==> (cleared)\n");
        } else if(itemcode == 1 && mode == 2) {
                printf("DISPLAY ==> Please mount volume `%.6s'\n",
                        &ti_media.ub[2]);
        } else if(itemcode == 1 && mode == 1) {
                printf("DISPLAY ==> Volume `%.6s' mounted\n",&ti_media.ub[2]);
        } else {                                /* undefined function */
                t_iosb.status = SSs_BADPARAM;
        }
}
 

static void tap_rew_unl(fcode)                  /* REWIND, REWINDOFF */
unsigned fcode;
{
        int retc;
 
/* ignore IOsM_NOWAIT ... */
        switch(fcode) {
          case IOs_REWIND:
                TRACE1("TAPREW",retc = TAPREW());
                break;
 
          case IOs_REWINDOFF:
                TRACE1("TAPRUN",retc = TAPRUN());
                t_eotrec = -1;
                t_unloaded = 1;
                MT_clr(MTsM_HWL);
                break;
        }
        t_iosb.status = tap2sts(retc);
        t_iosb.count = 0;
        MT_clr(MTsM_LOST | MTsM_EOT | MTsM_EOF);
        MT_set(MTsM_BOT);
        t_record = 0;
}
 
 
static void tap_skiprec()       /* skip records, forward/backward */
{
        if(ti_count == 0) {                     /* simulated IOs_NOP */
                t_iosb.count = 0;
                                                /* tape always loaded ... */
                if((t_iosb.devdep & MTsM_EOT)) {
                        t_iosb.status = SSs_ENDOFTAPE;
                } else {
                        t_iosb.status = SSs_NORMAL;
                }
 
        } else if(ti_count > 0) {               /* FORWARD */
                for(t_iosb.count = 0, t_iosb.status = SSs_NORMAL;
                    t_iosb.count < ti_count && (t_iosb.status & 1);
                    t_iosb.count ++) {
#ifdef FAKE_FSR
			{
			  unsigned int cnt,sts;

			  sts = tap2sts(TRACE1("TAPRD-FSR",
					       TAPRD(t_buffer,0xFFFF,&cnt)));
			  t_iosb.status = (sts == SSs_DATAOVERUN) ? 
			    		  SSs_NORMAL : sts;
			}
#else
                        t_iosb.status = tap2sts(TRACE1("TAPFSR",TAPFSR()));
#endif
                        t_record ++;
                                /* assume that tape moved even on error ... */
                                /* NOT true at end of written area ...      */
                }
                if(t_iosb.status == SSs_ENDOFFILE) {
                        MT_set(MTsM_EOF);
                } else {
                        MT_clr(MTsM_EOF);
                }
                if(t_record > 0) MT_clr(MTsM_BOT);
                if(t_eotrec >= 0 && t_record >= t_eotrec) {
                        MT_set(MTsM_EOT);
                        if(t_iosb.status & 1) {
                                t_iosb.status = SSs_ENDOFTAPE;
                        }
                }
 
        } else {                                /* BACKWARD */
                int sc;
 
                sc = - ti_count;
 
                t_iosb.count = 0;
                do {
                        if(t_record == 0) {
                                t_iosb.status = SSs_BEGOFTAPE;
                        } else {
                                t_iosb.status = tap2sts(TRACE1("TAPBSR",TAPBSR()));
                                if(t_iosb.status & 1 ||
                                   (t_iosb.status == SSs_ENDOFFILE)) {
                                        t_record --;
                                        t_iosb.count ++;
                                } else {
                                        /* error, assume NO movement, so */
                                        /* t_record won't be 0 too early */
                                }
                        }
                } while(t_iosb.count < sc && (t_iosb.status & 1));
 
                if(t_iosb.status == SSs_ENDOFFILE) {
                        MT_set(MTsM_EOF);
                } else {
                        MT_clr(MTsM_EOF);
                }
                if(t_record == 0) MT_set(MTsM_BOT);
                if(t_record < t_eotrec) {
                        MT_clr(MTsM_EOT);
                }
                /* note that space backward does NOT return ENDOFTAPE */
        }
}
 
 
static void tap_read_wchk(wchk) /* wchk==0: read, possibly w/datacheck */
int wchk;                       /* wchk==1: simulated writecheck */
{
/* ignore IOsM_DATACHECK ... */
        int cnt;
 
 
        ti_count &= 0xFFFF;             /* fudge, safety only */
 
        cnt = 0xFFFF;                   /* allow for VMS maximum */
        t_iosb.status = tap2sts(TRACE1("TAPRD",TAPRD(t_buffer,cnt,&cnt)));
        if((t_iosb.status & 1) &&
           (cnt > ti_count)) {          /* fixup status */
                t_iosb.status = SSs_DATAOVERUN;
        }
 
        t_record ++;            /* assume that tape moved even on error ... */
                                /* NOT true at end of written area ...      */
        MT_clr(MTsM_BOT);
 
        if(t_eotrec >= 0 && t_record >= t_eotrec) {
                MT_set(MTsM_EOT);
        }
        if(t_iosb.status == SSs_ENDOFFILE) {
                MT_set(MTsM_EOF);
        } else {
                MT_clr(MTsM_EOF);
        }
        if((t_iosb.status & 1) || t_iosb.status == SSs_DATAOVERUN) {
                t_iosb.count = cnt;
        } else {
                t_iosb.count = 0;
        }
 
        if(t_iosb.count > 0) {
                int bcnt,c;
                unsigned char *bpt;
 
                no_buf.count = bcnt = MIN(t_iosb.count,ti_count);
                net_send(wchk ? ZTNS_F_C_DATA : ZTNS_F_R_DATA);
                bpt = t_buffer;
                do {
                        no_buf.count = c = MIN(bcnt,ZTNS_DATALEN);
                        bcnt -= c;
                        memcpy(no_buf.data,bpt,c);
                        bpt += c;
                        net_send(ZTNS_F_DATA);
                } while(bcnt > 0);
 
                net_rcv(ZTNS_F_IOREPLY);        /* wait for reply */
 
                if((ti_replysts & 1) == 0) {
                        if(wchk) {      /* CMP may have error = SSs_DATACHECK */
                                t_iosb.status = ti_replysts;
                        } else {        /* GET must be o.k. */
                                FEHLER("prot.error: bad status for read DATA");
                        }
                }
        }
}
 
 
static void tap_wtm()                           /* WRITEOF */
{
        if(t_record < t_eotrec) {
                t_eotrec = -1;
                MT_clr(MTsM_EOT);
        }
 
        t_iosb.status = tap2sts(TRACE1("TAPWTM",TAPWTM()));
        if((t_iosb.status & 1) ||
           (t_iosb.status == SSs_ENDOFFILE)) {
                t_record ++;                    /* only on good status */
                MT_clr(MTsM_BOT);
                MT_set(MTsM_EOF);
        }
        if(t_iosb.status == SSs_ENDOFFILE) {
                t_iosb.status = SSs_ENDOFTAPE;
                MT_set(MTsM_EOT);
                if(t_eotrec == -1) t_eotrec = t_record;
        } else if((t_iosb.status & 1) &&
                  (t_iosb.devdep & MTsM_EOT)) {
                t_iosb.status = SSs_ENDOFTAPE;
        }
        t_iosb.count = 0;
}
 
 
static void tap_write()         /* write, possibly w/datacheck */
{
/* ignore IOsM_DATACHECK ... */
        if(ti_count > 0) {
                no_buf.count = ti_datacnt = (ti_count & 0xFFFF);
                ti_datap = t_buffer;
 
                net_send(ZTNS_F_W_DATA);
 
                net_rcv(ZTNS_F_DATA);
        }
 
        if(t_record < t_eotrec) {
                t_eotrec = -1;
                MT_clr(MTsM_EOT);
        }
 
        t_iosb.status = tap2sts(TRACE1("TAPWR",TAPWR(t_buffer,ti_count)));
        if((t_iosb.status & 1) ||
           (t_iosb.status == SSs_ENDOFFILE)) {
                t_record ++;                    /* only on good status */
                MT_clr(MTsM_BOT);
                MT_clr(MTsM_EOF);
        }
        if(t_iosb.status == SSs_ENDOFFILE) {
                t_iosb.status = SSs_ENDOFTAPE;
                MT_set(MTsM_EOT);
                if(t_eotrec == -1) t_eotrec = t_record;
                t_iosb.count = ti_count;
        } else if(t_iosb.status & 1) {
                if(t_iosb.devdep & MTsM_EOT) {
                        t_iosb.status = SSs_ENDOFTAPE;
                }
                t_iosb.count = ti_count;
        } else {
                t_iosb.count = 0;
        }
}
 
 
/*****/
 
static unsigned load_tape()     /* request next tape.
                                /* return:
                                /*      1 - ok
                                /*      0 - terminate program */
{
        char cmd[2];
        int n;
 
 
        do {
                fprintf(stderr,
                        "Load next tape and enter G, or enter X to stop\n");
                fflush(stderr);
                n = fscanf(stdin,"%1s",cmd);
        } while(n == 0 ||
                (n == 1 && !(cmd[0] == 'X' || cmd[0] == 'G')));
 
        if(n == EOF || cmd[0] == 'X') {
                return 0;
        } else {
		(void) TRACE1("TAPREW",TAPREW());	/* get HWL */
		if(TAPE_HWL) MT_set(MTsM_HWL);

                t_unloaded = 0;
                return 1;
        }
}
 
 
static unsigned ztns()          /* the action routine */
{
        unsigned fcode,fmodif;
 
#define TEST_IF_LOADED if(t_unloaded) {\
                unsigned sts = load_tape();\
                if((sts & 1) == 0) return sts;} else {}
 
 
        while(1) {
 
/* get next function */
                net_rcv(ZTNS_F_IOREQ);
 
/* check & dispatch function */
                fcode = ti_iofunc & IOsM_FCODE;
                fmodif = ti_iofunc & IOsM_FMODIFIERS;
                switch(fcode) {
 
                  case IOs_WRITEOF:     /* no modifiers */
                        TEST_IF_LOADED;
                        if(fmodif != 0) {
                                tap_invfun();
                        } else {
                                tap_wtm();
                        }
                        break;
 
                  case IOs_REWIND:      /* mod: NOWAIT */
                  case IOs_REWINDOFF:   /* mod: NOWAIT */
                        if((fmodif & ~IOsM_NOWAIT) != 0) {
                                tap_invfun();
                        } else if(t_unloaded) {         /* this is allowed */
                                t_iosb.status = SSs_MEDOFL;
                                t_iosb.count = 0;
                        } else {
                                tap_rew_unl(fcode);
                        }
                        break;
 
                  case IOs_SKIPRECORD:  /* no modifiers */
                        TEST_IF_LOADED;
                        if(fmodif != 0) {
                                tap_invfun();
                        } else {
                                tap_skiprec();
                        }
                        break;
 
                  case IOs_READLBLK:    /* mod: datacheck */
                                        /* note: datacheck is not end-to-end */
                        TEST_IF_LOADED;
                        if((fmodif & ~IOsM_DATACHECK) != 0) {
                                tap_invfun();
                        } else {
                                tap_read_wchk(0);
                        }
                        break;
 
                  case IOs_WRITELBLK:   /* mod: datacheck */
                                        /* note: datacheck is not end-to-end */
                        TEST_IF_LOADED;
                        if((fmodif & ~IOsM_DATACHECK) != 0) {
                                tap_invfun();
                        } else {
                                tap_write();
                        }
                        break;
 
                  case IOs_WRITECHECK:  /* no modifiers */
                                        /* note: this is PHYSICAL I/O,
                                        simulated as end-to-end check */
                        TEST_IF_LOADED;
                        if(fmodif != 0) {
                                tap_invfun();
                        } else {
                                tap_read_wchk(1);
                        }
                        break;
 
		  case IOs_DISPLAY:     /* no modifiers */
                                        /* reduced data come in IOSB (dirty!) */
                        if(fmodif != 0) {
                                tap_invfun();
			} else {
                                tap_display();
			}
                        break;

                  default:
                        tap_invfun();
                }
 
/* return result from t_iosb */
                no_buf.iosb = t_iosb;
                net_send(ZTNS_F_IOREPLY);
        }
}
 
 
/*****/
 
static void tcp_start(), tcp_term();      /* forward */
 
 
main(argc,argv)         /* argv[1] = port number (listening for VMS client) */
int argc;
char **argv;
{
        unsigned status;
 
 
        if(argc < 2) {
                fprintf(stderr,"usage: %s  portnumber\n",argv[0]);
                exit(1);
        }
 
 
/* rewind tape. this MUST succeed, otherwise something is wrong */
 
        if((tap2sts(TRACE1("TAPREW",TAPREW())) & 1) == 0) {
                FEHLER("tape in error, bad status on REW");
        }
        t_iosb.devdep = MTsM_BOT;       /* don't know about HWL */
	if(TAPE_HWL) MT_set(MTsM_HWL);	/* but maybe this will tell ... */
 
 
/* start the network connection & remote ZTserver */
 
        tcp_start(argv[1]);
 
 
/* do our work ... */
 
        do {
                status = ztns();
        } while(status & 1);
 
 
/* terminate network connection */
 
        tcp_term();
 
 
/* all done */
 
        exit(status);
}
 
 
/*****/
 
static void ztns_swap(mp)       /* convert ZTNS_MSG in place, VAX <-> IBM */
ZTNS_MSG *mp;
{
  {	/* test for this machine's endian-ness */
    static int c1 = 1;
    int bigendian;

    bigendian = ( *((char *)(&c1)) != 1 );
    if(!bigendian) return;	/* VAX is little-endian => NOOP */
  }

#define SWAP_2(x) do {unsigned char t,*p=(unsigned char *)(x);\
                        t=p[0];p[0]=p[1];p[1]=t;} while(0)
#define SWAP_4(x) do {unsigned char t,*p=(unsigned char *)(x);\
                        t=p[0];p[0]=p[3];p[3]=t;\
                        t=p[1];p[1]=p[2];p[2]=t;} while(0)
			  
  SWAP_4(&(mp->seq));
  SWAP_2(&(mp->func));
  SWAP_2(&(mp->iofunc));
  SWAP_4(&(mp->count));
  SWAP_2(&(mp->iosb.status));
  SWAP_2(&(mp->iosb.count));
  SWAP_4(&(mp->iosb.devdep));
}
 
/*****/

#include <stdio.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/uio.h>
#include <netinet/tcp.h>

static int tcp_socket_c,tcp_socket_d;
static int/*logical*/ tcp_open = 0;
 
 
static void printsocknam(char *txt, struct sockaddr_in *snp)
{
  struct hostent *hep;
  unsigned char *p;

  hep = gethostbyaddr((char *)&(snp->sin_addr.s_addr),
		      sizeof(snp->sin_addr.s_addr),
		      AF_INET);

  p = (unsigned char *) &(snp->sin_addr.s_addr);
  printf("%s: %s (%d.%d.%d.%d) port %d\n",
	 txt,
	 hep ? hep->h_name : "???",
	 p[0],p[1],p[2],p[3],
	 ntohs(snp->sin_port));
}


static void tcp_start(aport)              /* open connection */
char *aport;     /* ascii port number */
{
  static struct sockaddr_in sock2_name,sock3_name;
  struct hostent *hostentptr;
  int retval,namelength;			


  /* create tcp_socket_c for listen() */
  if ((tcp_socket_c = socket (AF_INET, SOCK_STREAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }

  /* Fill in the name & address structure for tcp_socket_c */
  sock2_name.sin_family = AF_INET;
  sock2_name.sin_port = htons(atoi(aport));
  sock2_name.sin_addr.s_addr = INADDR_ANY;

  /* Bind name to tcp_socket_c */
  retval = bind (tcp_socket_c, &sock2_name, sizeof sock2_name);
  if (retval) {
    perror("bind");
    abort();
  }

  printsocknam("listening on socket",&sock2_name);
 
  /* Listen on tcp_socket_c for connections */
  retval = listen (tcp_socket_c, 5);
  if (retval) {
    perror("listen");
    abort();
  }

  /* Accept connection from tcp_socket_c on tcp_socket_d */
  namelength = sizeof(sock3_name);
  tcp_socket_d = accept (tcp_socket_c, &sock3_name, &namelength);
  if (tcp_socket_d == -1) {
    perror ("accept");
    abort();
  }

  printsocknam("accepted socket",&sock3_name);

  /* set TCP_NODELAY */
  {
    int on=1;

    if(setsockopt(tcp_socket_d,IPPROTO_TCP,TCP_NODELAY,&on,sizeof(on))) {
      perror("setsockopt");
      exit(1);
    }
  }

  tcp_open = 1;
}
 
 
static void tcp_send(data,nbyt)
void *data;
int nbyt;
{
#ifdef DBG
  printf("tcp_send: %d bytes\n",nbyt);
#endif

  if(data != &(tcp_no_buf.nobuf)) FEHLER("tcp_send: data != tcp_no_buf.nobuf");

  tcp_no_buf.l[0] = nbyt % 256;
  tcp_no_buf.l[1] = nbyt / 256;
  if(send(tcp_socket_d,&(tcp_no_buf.l[0]),2 + nbyt,0) < 0) {
    perror("send");
    abort();
  }
}

static int my_recv(int sock, void *buf, int len, int flags)
{
  unsigned char *bp;
  int k,l;

  l = len;
  bp = (unsigned char *) buf;

  while(l > 0) {
    k = recv(sock,bp,l,flags);
    if(k < 0) return k;
    l -= k;
    bp += k;
  }
  return len;
}

static int tcp_rcv(data,nbyt)
char *data;
int nbyt;
{
  int nbi;
  unsigned char l[2];
 
  if(my_recv(tcp_socket_d,l,2,0) < 0) {
    perror("recv(len)");
    abort();
  }

  nbi = 256 * l[1] + l[0];
#ifdef DBG
  printf("tcp_rcv: %d bytes\n",nbi);
#endif
  if(nbi > nbyt) {
    fprintf(stderr,"tcp_rcv: too much data, nb=%d\n",nbi);
    abort();
  }

  if(my_recv(tcp_socket_d,data,nbi,0) < 0) {
    perror("recv(data)");
    abort();
  }
  
  return nbi;
}
 
 
static void tcp_term()           /* close connection */
{
  /* no-op */
}
 
 
/******************************************************************************/
/* abort with msg to stderr */
 
static void FEHLER(str)
char *str;
{
        fprintf(stderr,"%s\n",str);
        fflush(stderr);
 
        tcp_term();
 
        exit(99);
}
