/* NULL_device (write-only) emulation of 'SIMPLE VM/CMS MAGTAPE FUNCTIONS'
 *
 * w.j.m. aug 1994 (after ZT1D.UIO_C dated 28-feb-1994)
 *
 * int TAPRD(void *buffer,int size,int *trans) => 7 ("invalid device")
 * int TAPWR(void *buffer,int size)            => 0 (noop)
 * int TAPBSR()		backspace 1 block      => 2 ("eof")
 * int TAPFSR()		forward space 1 block  => 2 ("eof")
 * int TAPWTM()		write tape mark        => 0 (noop)
 * int TAPREW()		rewind                 => 0 (noop)
 * int TAPRUN()		rewind+unload          => 0 (noop)
 *
 * Result (see VM/SP CMS command & macros manual):
 *       0 => o.k.
 *       2 => EOF or EOT
 *       7 => [invalid device attached]
 */

#ifdef TAP2	/* re-name TAP* routines to TAP2* */
#define TAPRD TAP2RD
#define TAPWR TAP2WR
#define TAPBSR TAP2BSR
#define TAPFSR TAP2FSR
#define TAPWTM TAP2WTM
#define TAPREW TAP2REW
#define TAPRUN TAP2RUN
#define TAPSHOW TAP2SHOW
#endif	/* TAP2 */


int TAPRD(void *buf, int siz, int *trp)
{
  return 7;
}


int TAPWR(void *buf,int siz)
{
  return 0;
}


int TAPBSR(void)
{
  return 2;
}


int TAPFSR(void)
{
  return 2;
}

int TAPWTM(void)
{
  return 0;
}


int TAPREW(void)
{
  return 0;
}


int TAPRUN(void)
{
  return 0;
}


/* debug only? */

int TAPSHOW(void)
{
  /* no-op so far */
  return 0;
}
