/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.location.LocationInfo;

public class XMLLayout
extends Layout {
    private boolean locationInfo = false;

    public XMLLayout() {
        this.ignoresThrowable = false;
    }

    public void setLocationInfo(boolean flag) {
        this.locationInfo = flag;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        Set propertySet;
        String[] s;
        output.write("<log4j:event logger=\"");
        output.write(event.getLoggerName());
        output.write("\" timestamp=\"");
        output.write(Long.toString(event.getTimeStamp()));
        output.write("\" sequenceNumber=\"");
        output.write(Long.toString(event.getSequenceNumber()));
        output.write("\" level=\"");
        output.write(event.getLevel().toString());
        output.write("\" thread=\"");
        output.write(event.getThreadName());
        output.write("\">\r\n");
        output.write("<log4j:message><![CDATA[");
        Transform.appendEscapingCDATA(output, event.getRenderedMessage());
        output.write("]]></log4j:message>\r\n");
        String ndc = event.getNDC();
        if (ndc != null) {
            output.write("<log4j:NDC><![CDATA[");
            output.write(ndc);
            output.write("]]></log4j:NDC>\r\n");
        }
        if (!this.ignoresThrowable && (s = event.getThrowableStrRep()) != null) {
            output.write("<log4j:throwable><![CDATA[");
            int i = 0;
            while (i < s.length) {
                output.write(s[i]);
                output.write("\r\n");
                ++i;
            }
            output.write("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            LocationInfo locationInfo = event.getLocationInformation();
            output.write("<log4j:locationInfo class=\"");
            output.write(locationInfo.getClassName());
            output.write("\" method=\"");
            Transform.escapeTags(locationInfo.getMethodName(), output);
            output.write("\" file=\"");
            output.write(locationInfo.getFileName());
            output.write("\" line=\"");
            output.write(locationInfo.getLineNumber());
            output.write("\"/>\r\n");
        }
        if ((propertySet = event.getPropertyKeySet()) != null && propertySet.size() > 0) {
            output.write("<log4j:properties>\r\n");
            Iterator propIter = propertySet.iterator();
            while (propIter.hasNext()) {
                String propName = propIter.next().toString();
                output.write("    <log4j:data name=\"" + propName);
                String propValue = event.getProperty(propName).toString();
                output.write("\" value=\"" + propValue);
                output.write("\"/>\r\n");
            }
            output.write("</log4j:properties>\r\n");
        }
        output.write("</log4j:event>\r\n\r\n");
    }
}

