/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.selector.servlet;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.JNDIUtil;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;

public class ContextDetachingSCL
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent sce) {
        String loggingContextName = null;
        try {
            Context ctx = JNDIUtil.getInitialContext();
            loggingContextName = JNDIUtil.lookup(ctx, "java:comp/env/log4j/context-name");
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (loggingContextName != null) {
            System.out.println("About to detach logger context named [" + loggingContextName + "].");
            RepositorySelector repositorySelector = LogManager.getRepositorySelector();
            LoggerRepository lr = repositorySelector.detachRepository(loggingContextName);
            if (lr != null) {
                Logger logger = lr.getLogger(this.getClass().getName());
                logger.debug((Object)"About to shutdown logger repository named [{}]", lr.getName());
                lr.shutdown();
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
    }
}

