/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling.helper;

import java.util.Date;
import org.apache.log4j.rolling.helper.DateTokenConverter;
import org.apache.log4j.rolling.helper.IdentityTokenConverter;
import org.apache.log4j.rolling.helper.IntegerTokenConverter;
import org.apache.log4j.rolling.helper.TokenConverter;
import org.apache.log4j.spi.ComponentBase;

public class FileNamePattern
extends ComponentBase {
    String pattern;
    int patternLength;
    TokenConverter headTokenConverter;

    public FileNamePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("The argument to constrcutor cannot be null. ");
        }
        this.pattern = pattern;
        if (pattern != null) {
            this.patternLength = pattern.length();
            this.pattern = this.pattern.trim();
        }
        this.parse();
    }

    public String toString() {
        return this.pattern;
    }

    void parse() {
        block10: {
            int i;
            int lastIndex = 0;
            TokenConverter tc = null;
            block5: while (true) {
                if ((i = this.pattern.indexOf(37, lastIndex)) == -1) {
                    String remainingStr = this.pattern.substring(lastIndex);
                    this.addTokenConverter(tc, new IdentityTokenConverter(remainingStr));
                    break block10;
                }
                if (i == this.patternLength - 1) {
                    String remainingStr = this.pattern.substring(lastIndex);
                    this.addTokenConverter(tc, new IdentityTokenConverter(remainingStr));
                    break block10;
                }
                tc = this.addTokenConverter(tc, new IdentityTokenConverter(this.pattern.substring(lastIndex, i)));
                char nextChar = this.pattern.charAt(i + 1);
                switch (nextChar) {
                    case 'i': {
                        tc = this.addTokenConverter(tc, new IntegerTokenConverter());
                        lastIndex = i + 2;
                        continue block5;
                    }
                    case 'd': {
                        String option;
                        int optionEnd = this.getOptionEnd(i + 2);
                        if (optionEnd != -1) {
                            option = this.pattern.substring(i + 3, optionEnd);
                            lastIndex = optionEnd + 1;
                        } else {
                            this.getLogger().debug("Assuming daily rotation schedule");
                            option = "yyyy-MM-dd";
                            lastIndex = i + 2;
                        }
                        tc = this.addTokenConverter(tc, new DateTokenConverter(option));
                        continue block5;
                    }
                    case '%': {
                        tc = this.addTokenConverter(tc, new IdentityTokenConverter("%"));
                        lastIndex = i + 2;
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("The pattern[" + this.pattern + "] does not contain a valid specifer at position " + (i + 1));
        }
    }

    protected int getOptionEnd(int i) {
        if (i < this.patternLength && this.pattern.charAt(i) == '{') {
            int end = this.pattern.indexOf(125, i);
            if (end > i) {
                return end;
            }
            return -1;
        }
        return -1;
    }

    TokenConverter addTokenConverter(TokenConverter tc, TokenConverter newTokenConverter) {
        if (tc == null) {
            tc = this.headTokenConverter = newTokenConverter;
        } else {
            tc.next = newTokenConverter;
            tc = newTokenConverter;
        }
        return tc;
    }

    public DateTokenConverter getDateTokenConverter() {
        TokenConverter p = this.headTokenConverter;
        while (p != null) {
            if (p.getType() == 1) {
                return (DateTokenConverter)p;
            }
            p = p.getNext();
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        TokenConverter p = this.headTokenConverter;
        while (p != null) {
            if (p.getType() == 1) {
                return (IntegerTokenConverter)p;
            }
            p = p.getNext();
        }
        return null;
    }

    public String convert(int i) {
        TokenConverter p = this.headTokenConverter;
        StringBuffer buf = new StringBuffer();
        while (p != null) {
            switch (p.getType()) {
                case 0: {
                    buf.append(((IdentityTokenConverter)p).convert());
                    break;
                }
                case 1: {
                    buf.append(((IntegerTokenConverter)p).convert(i));
                    break;
                }
                default: {
                    this.getLogger().error("Encountered an unknown TokenConverter type for pattern [" + this.pattern + "].");
                }
            }
            p = p.getNext();
        }
        return buf.toString();
    }

    public String convert(Date date) {
        TokenConverter p = this.headTokenConverter;
        StringBuffer buf = new StringBuffer();
        while (p != null) {
            switch (p.getType()) {
                case 0: {
                    buf.append(((IdentityTokenConverter)p).convert());
                    break;
                }
                case 1: {
                    buf.append(((DateTokenConverter)p).convert(date));
                    break;
                }
                default: {
                    this.getLogger().error("Encountered an unknown TokenConverter type for pattern [" + this.pattern + "].");
                }
            }
            p = p.getNext();
        }
        return buf.toString();
    }

    public String getPattern() {
        return this.pattern;
    }
}

