/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.util.Date;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.rolling.helper.Compress;
import org.apache.log4j.rolling.helper.DateTokenConverter;
import org.apache.log4j.rolling.helper.FileNamePattern;
import org.apache.log4j.rolling.helper.RollingCalendar;
import org.apache.log4j.rolling.helper.Util;

public class TimeBasedRollingPolicy
extends RollingPolicyBase
implements TriggeringPolicy {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using TimeBasedRollingPolicy. ";
    static final String SEE_FNP_NOT_SET = "See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set";
    RollingCalendar rc;
    long nextCheck;
    Date lastCheck = new Date();
    String elapsedPeriodsFileName;
    FileNamePattern activeFileNamePattern;
    Util util = new Util();
    Compress compress = new Compress();

    public void activateOptions() {
        this.util.setLoggerRepository(this.repository);
        this.compress.setLoggerRepository(this.repository);
        if (this.fileNamePatternStr == null) {
            this.getLogger().warn(FNP_NOT_SET);
            this.getLogger().warn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using TimeBasedRollingPolicy. See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr);
        this.fileNamePattern.setLoggerRepository(this.repository);
        this.determineCompressionMode();
        DateTokenConverter dtc = this.fileNamePattern.getDateTokenConverter();
        if (dtc == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid DateToken");
        }
        int len = this.fileNamePatternStr.length();
        switch (this.compressionMode) {
            case 1: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 3));
                break;
            }
            case 2: {
                this.activeFileNamePattern = new FileNamePattern(this.fileNamePatternStr.substring(0, len - 4));
                break;
            }
            case 0: {
                this.activeFileNamePattern = this.fileNamePattern;
            }
        }
        this.getLogger().info((Object)"Will use the pattern {} for the active file", this.activeFileNamePattern);
        this.rc = new RollingCalendar();
        this.rc.init(dtc.getDatePattern());
        this.getLogger().debug("The date pattern is '{}' from file name pattern '{}'.", dtc.getDatePattern(), this.fileNamePattern.getPattern());
        this.rc.printPeriodicity(this.getLogger());
        long n = System.currentTimeMillis();
        this.lastCheck.setTime(n);
        this.nextCheck = this.rc.getNextCheckMillis(this.lastCheck);
    }

    public void rollover() throws RolloverFailure {
        this.getLogger().debug("rollover called");
        this.getLogger().debug("compressionMode: " + this.compressionMode);
        if (this.activeFileName == null) {
            switch (this.compressionMode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.getLogger().debug((Object)"GZIP compressing [{}]", this.elapsedPeriodsFileName);
                    this.compress.GZCompress(this.elapsedPeriodsFileName);
                    break;
                }
                case 2: {
                    this.getLogger().debug((Object)"ZIP compressing [{}]", this.elapsedPeriodsFileName);
                    this.compress.ZIPCompress(this.elapsedPeriodsFileName);
                }
            }
        } else {
            switch (this.compressionMode) {
                case 0: {
                    this.util.rename(this.activeFileName, this.elapsedPeriodsFileName);
                    break;
                }
                case 1: {
                    this.getLogger().debug((Object)"GZIP compressing [[}]", this.elapsedPeriodsFileName);
                    this.compress.GZCompress(this.activeFileName, this.elapsedPeriodsFileName);
                    break;
                }
                case 2: {
                    this.getLogger().debug((Object)"ZIP compressing [[}]", this.elapsedPeriodsFileName);
                    this.compress.ZIPCompress(this.activeFileName, this.elapsedPeriodsFileName);
                }
            }
        }
    }

    public String getActiveFileName() {
        this.getLogger().debug("getActiveLogFileName called");
        if (this.activeFileName == null) {
            return this.activeFileNamePattern.convert(this.lastCheck);
        }
        return this.activeFileName;
    }

    public boolean isTriggeringEvent(File file) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.getLogger().debug("Time to trigger rollover");
            this.elapsedPeriodsFileName = this.activeFileNamePattern.convert(this.lastCheck);
            this.getLogger().debug((Object)"elapsedPeriodsFileName set to {}", this.elapsedPeriodsFileName);
            this.lastCheck.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.lastCheck);
            Date x = new Date();
            x.setTime(this.nextCheck);
            this.getLogger().debug((Object)"Next check on {}", x);
            return true;
        }
        return false;
    }
}

