/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;

public class RollingFileAppender
extends FileAppender {
    File activeFile;
    TriggeringPolicy triggeringPolicy;
    RollingPolicy rollingPolicy;

    public void activateOptions() {
        if (this.triggeringPolicy == null) {
            this.getLogger().warn((Object)"Please set a TriggeringPolicy for the RollingFileAppender named '{}'", this.getName());
            return;
        }
        if (this.rollingPolicy != null) {
            String afn = this.rollingPolicy.getActiveFileName();
            this.activeFile = new File(afn);
            this.getLogger().debug("Active log file name: " + afn);
            this.setFile(afn);
            this.activeFile = new File(afn);
            super.activateOptions();
        } else {
            this.getLogger().warn("Please set a rolling policy");
        }
    }

    public void rollover() {
        this.closeWriter();
        boolean append = false;
        try {
            this.rollingPolicy.rollover();
        }
        catch (RolloverFailure rf) {
            this.getLogger().warn("RolloverFailure occurred. Deferring rollover.");
            append = true;
        }
        this.fileName = this.rollingPolicy.getActiveFileName();
        this.getLogger().debug((Object)"Active file name is now [{}].", this.fileName);
        this.activeFile = new File(this.fileName);
        try {
            this.setFile(this.fileName, append, this.bufferedIO, this.bufferSize);
        }
        catch (IOException e) {
            this.getLogger().error((Object)("setFile(" + this.fileName + ", false) call failed."), e);
        }
    }

    protected void subAppend(LoggingEvent event) {
        if (this.triggeringPolicy.isTriggeringEvent(this.activeFile)) {
            this.getLogger().debug("About to rollover");
            this.rollover();
        }
        super.subAppend(event);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)((Object)policy);
        }
    }

    public void setTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicy = policy;
        if (policy instanceof RollingPolicy) {
            this.rollingPolicy = (RollingPolicy)((Object)policy);
        }
    }
}

