/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import org.apache.log4j.rolling.RollingPolicyBase;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.helper.Compress;
import org.apache.log4j.rolling.helper.FileNamePattern;
import org.apache.log4j.rolling.helper.IntegerTokenConverter;
import org.apache.log4j.rolling.helper.Util;

public class FixedWindowRollingPolicy
extends RollingPolicyBase {
    static final String FNP_NOT_SET = "The FileNamePattern option must be set before using FixedWindowRollingPolicy. ";
    static final String SEE_FNP_NOT_SET = "See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set";
    int maxIndex = 7;
    int minIndex = 1;
    Util util = new Util();
    Compress compress = new Compress();
    private static int MAX_WINDOW_SIZE = 12;

    public FixedWindowRollingPolicy() {
        this.activeFileName = null;
    }

    public void activateOptions() {
        IntegerTokenConverter itc;
        this.util.setLoggerRepository(this.repository);
        this.compress.setLoggerRepository(this.repository);
        if (this.fileNamePatternStr == null) {
            this.getLogger().warn(FNP_NOT_SET);
            this.getLogger().warn(SEE_FNP_NOT_SET);
            throw new IllegalStateException("The FileNamePattern option must be set before using FixedWindowRollingPolicy. See also http://logging.apache.org/log4j/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr);
        this.fileNamePattern.setLoggerRepository(this.repository);
        this.determineCompressionMode();
        if (this.activeFileName == null) {
            this.getLogger().warn("The ActiveFile name option must be set before using this rolling policy.");
            throw new IllegalStateException("The ActiveFileName option must be set.");
        }
        if (this.maxIndex < this.minIndex) {
            this.getLogger().warn("MaxIndex (" + this.maxIndex + ") cannot be smaller than MinIndex (" + this.minIndex + ").");
            this.getLogger().warn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        if (this.maxIndex - this.minIndex > MAX_WINDOW_SIZE) {
            this.getLogger().warn("Large window sizes are not allowed.");
            this.maxIndex = this.minIndex + MAX_WINDOW_SIZE;
            this.getLogger().warn((Object)"MaxIndex reduced to {}.", new Integer(this.maxIndex));
        }
        if ((itc = this.fileNamePattern.getIntegerTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid IntegerToken");
        }
    }

    public void rollover() throws RolloverFailure {
        if (this.maxIndex >= 0) {
            File file = new File(this.fileNamePattern.convert(this.maxIndex));
            if (file.exists()) {
                file.delete();
            }
            int i = this.maxIndex - 1;
            while (i >= this.minIndex) {
                String toRenameStr = this.fileNamePattern.convert(i);
                File toRename = new File(toRenameStr);
                if (toRename.exists()) {
                    this.util.rename(toRenameStr, this.fileNamePattern.convert(i + 1));
                } else {
                    this.getLogger().info((Object)"Skipping rollover for inexistent file {}", toRenameStr);
                }
                --i;
            }
            switch (this.compressionMode) {
                case 0: {
                    this.util.rename(this.activeFileName, this.fileNamePattern.convert(this.minIndex));
                    break;
                }
                case 1: {
                    this.compress.GZCompress(this.activeFileName, this.fileNamePattern.convert(this.minIndex));
                    break;
                }
                case 2: {
                    this.compress.ZIPCompress(this.activeFileName, this.fileNamePattern.convert(this.minIndex));
                }
            }
        }
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }
}

