/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class PropertiesPatternConverter
extends PatternConverter {
    String name;
    String option;

    public StringBuffer convert(LoggingEvent event) {
        StringBuffer buf = new StringBuffer(32);
        if (this.option == null) {
            buf.append("{");
            Set keySet = event.getPropertyKeySet();
            Iterator i = keySet.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                String val = event.getProperty(item.toString());
                buf.append("{").append(item).append(",").append((Object)val).append("}");
            }
            buf.append("}");
            return buf;
        }
        String val = event.getProperty(this.option);
        if (val != null) {
            return buf.append((Object)val);
        }
        return buf;
    }

    public void setOptions(List optionList) {
        if (optionList == null || optionList.size() == 0) {
            return;
        }
        this.option = (String)optionList.get(0);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.option != null ? this.name + "Property{" + this.option + "}" : "Properties";
        }
        return this.name;
    }

    public String getStyleClass(LoggingEvent e) {
        return "property";
    }
}

