/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public abstract class PatternConverter
extends ComponentBase {
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    LoggerRepository repository;

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo fi) {
        this.min = fi.min;
        this.max = fi.max;
        this.leftAlign = fi.leftAlign;
    }

    public void setFormattingInfo(FormattingInfo fi) {
        this.min = fi.min;
        this.max = fi.max;
        this.leftAlign = fi.leftAlign;
    }

    protected abstract StringBuffer convert(LoggingEvent var1);

    public void format(Writer output, LoggingEvent e) throws IOException {
        StringBuffer s = this.convert(e);
        if (s == null) {
            if (0 < this.min) {
                this.spacePad(output, this.min);
            }
            return;
        }
        int len = s.length();
        if (len > this.max) {
            output.write(s.substring(len - this.max));
        } else if (len < this.min) {
            if (this.leftAlign) {
                output.write(s.toString());
                this.spacePad(output, this.min - len);
            } else {
                this.spacePad(output, this.min - len);
                output.write(s.toString());
            }
        } else {
            output.write(s.toString());
        }
    }

    public void spacePad(Writer output, int length) throws IOException {
        while (length >= 32) {
            output.write(SPACES[5]);
            length -= 32;
        }
        int i = 4;
        while (i >= 0) {
            if ((length & 1 << i) != 0) {
                output.write(SPACES[i]);
            }
            --i;
        }
    }

    public void setOptions(List options) {
    }

    public abstract String getName();

    public abstract String getStyleClass(LoggingEvent var1);

    public boolean handlesThrowable() {
        return false;
    }

    public static boolean chainHandlesThrowable(PatternConverter head) {
        PatternConverter c = head;
        while (c != null) {
            if (c.handlesThrowable()) {
                return true;
            }
            c = c.next;
        }
        return false;
    }
}

