/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.pattern.CachedDateFormat;
import org.apache.log4j.pattern.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public class DatePatternConverter
extends PatternConverter {
    private CachedDateFormat df;
    private final StringBuffer buf = new StringBuffer(30);

    public void setOptions(List optionList) {
        String patternOption = optionList == null || optionList.size() == 0 ? null : (String)optionList.get(0);
        String pattern = patternOption == null || patternOption.equalsIgnoreCase("ISO8601") ? "yyyy-MM-dd HH:mm:ss,SSS" : (patternOption.equalsIgnoreCase("ABSOLUTE") ? "HH:mm:ss,SSS" : (patternOption.equalsIgnoreCase("DATE") ? "dd MMM yyyy HH:mm:ss,SSS" : patternOption));
        int maximumCacheValidity = 1000;
        SimpleDateFormat simpleFormat = null;
        try {
            simpleFormat = new SimpleDateFormat(pattern);
            maximumCacheValidity = CachedDateFormat.getMaximumCacheValidity(pattern);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn((Object)("Could not instantiate SimpleDateFormat with pattern " + patternOption), e);
            simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        }
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone((String)optionList.get(1));
            simpleFormat.setTimeZone(tz);
        }
        this.df = new CachedDateFormat(simpleFormat, maximumCacheValidity);
    }

    public StringBuffer convert(LoggingEvent event) {
        this.buf.setLength(0);
        this.df.format(event.getTimeStamp(), this.buf);
        return this.buf;
    }

    public String getName() {
        return "Date";
    }

    public String getStyleClass(LoggingEvent e) {
        return "date";
    }
}

